<?php

namespace App\Http\Livewire\Dam;

use App\Enums\SituacaoEnum;
use App\Models\Dam;
use App\Models\InstituicaoFinanceira\BalancetePrestador;
use App\Services\Balancete\BuscaSequencialDam;
use App\Services\Balancete\CalculadoraValorDamBalancete;
use App\Services\Balancete\VerificadorDePrazoLimeteParaEnvio;
use App\Services\ZerosAEsquedaParaUmMes;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Livewire\Component;

class GerarDam extends Component
{
    public $alert;
    public $showButtons = true;
    public $balancete;
    public $instituicao;

    protected $listeners = ['obterBalanceteParaGerarDam'];
    protected VerificadorDePrazoLimeteParaEnvio $geranciadorDePrazoParaEnvio;
    public bool $envioEstaNoPrazo;
    public $dia_limite_envio;
    public $valor_multa;
    public $vencimento;

    public function render()
    {
        return view('livewire.dam.gerar-dam');
    }

    public function obterBalanceteParaGerarDam(string $balancete_uuid) : void
    {
        $this->balancete = BalancetePrestador::with('prestador')
            ->where('uuid', $balancete_uuid)->first();

        $this->geranciadorDePrazoParaEnvio = new VerificadorDePrazoLimeteParaEnvio($this->balancete);
        $this->envioEstaNoPrazo = $this->geranciadorDePrazoParaEnvio->balanceteEstaNoPrazo();

        $this->instituicao = Session::get('instituicao');

        $dadosPrazoLimite = $this->geranciadorDePrazoParaEnvio->buscarInformacoesParametrizacaoMulta($this->instituicao);
        $this->dia_limite_envio = $dadosPrazoLimite->dia_limite_envio;
        $this->valor_multa = $dadosPrazoLimite->valor_multa;
        $this->vencimento = $this->geranciadorDePrazoParaEnvio->vencimento();

    }

    public function gerar() : void
    {
        sleep(1);

        try {

            $sequencial = BuscaSequencialDam::gerar($this->instituicao->id);
            $competencia = $this->balancete->ano_competencia .'-'. ZerosAEsquedaParaUmMes::get($this->balancete->mes_competencia).'-01';

            $valor = (new CalculadoraValorDamBalancete(
                $this->balancete,
                $this->envioEstaNoPrazo,
                $this->valor_multa
            ))->obterValor();

            $dam = Dam::create([
                'situacao' => SituacaoEnum::REGULAR,
                'sequencial' => $sequencial,
                'data_inclusao' => Carbon::now(),
                'data_vencimento' => $this->vencimento,
                'competencia' => $competencia,
                'valor' => $valor,
                'tipo' => 1, //DAM(1, "DAM"), DAM_AVULSO(2, "DAM Avulso");
                'nosso_numero' => null,
                'id_prestador' => $this->balancete->prestador->id,
                'id_instituicao' => $this->instituicao->id,
                'linha_digitavel' => null,
                'observacao' => 'Gerado Online',
            ]);



        } catch (\Exception $exception) {

            Log::error("GerarDam::gerar - " . $exception->getMessage());

            dd('não gerou....', $this->balancete);
        }
    }

//    private function exibirMensagemForaDoPrazo()
//    {
//        $msn = "<strong>Atenção!</strong> <br> A data estabelecida para o envio do balancete sem multa é <strong> até o dia ";
//        $msn .= $this->dia_limite_envio. " de cada mês subsequente ao mês da competência.</strong> ";
//        $msn .= "Para os balancetes enviados após a data limite, <strong>será acrescida multa de ";
//        $msn .= $this->valor_multa. "% ao valor do DAM</strong> (Documento de Arrecadação Municipal).";
//
//        $this->mensagem_fora_de_prazo_modal = $msn;
//    }

}
