<?php

namespace App\Http\Livewire\BalanceteFinanceiro;

use App\Enums\MesEnum;
use App\Models\InstituicaoFinanceira\BalancetePrestador;
use App\View\ActionColumn;
use Rappasoft\LaravelLivewireTables\DataTableComponent;
use Rappasoft\LaravelLivewireTables\Views\Column;

class BalanceteDataTable extends DataTableComponent
{
    protected $model = BalancetePrestador::class;

    public function configure(): void
    {
        $this->setPrimaryKey('id');
        $this->setAdditionalSelects(['id', 'uuid', 'deleted_at', 'mes_competencia', 'created_at', 'updated_at']);
        $this->setEagerLoadAllRelationsStatus(true);
        $this->setEmptyMessage('Nenhum registro cadastrado.');
    }

    public function columns(): array
    {
        return [
            Column::make("Competência", 'ano_competencia')
                ->format(
                    fn($value, $row, Column $column) =>  '<strong>' . MesEnum::from($row->mes_competencia)->name . '/' . $row->ano_competencia . '</strong>'
                )->html()
            ->sortable()
            ->searchable(),

            Column::make('Histórico', 'historico')
                ->sortable()
                ->searchable(),

            Column::make('Balancete Enviado', 'historico')
                ->format(
                    fn($value, $row, Column $column) => $row->lancamentos->count() > 0
                        ? '<span class="badge rounded-pill bg-success">Sim</span>'
                        : '<span class="badge rounded-pill bg-secondary">Não</span>'
                )->html()
                ->sortable()
                ->searchable(),

            ActionColumn::make('Informações', 'created_at')
                ->setView('livewire.balancete-financeiro._includes._info_criacao_atualizacao'),

            ActionColumn::make('', 'uuid')
                ->setView('livewire.balancete-financeiro._includes._btns-actions')
        ];
    }
}
