<?php

namespace App\Http\Livewire\AgenciaFinanceira__old;

use App\Enums\StatusPadraoEnum;
use App\Models\InstituicaoFinanceira\AgenciasFinanceiras;
use App\Models\InstituicaoFinanceira\InstituicaoFinanceira;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Livewire\Component;
use PHPUnit\Exception;

class CreateAgenciaModal extends Component
{
    public $nome;
    public $codigo;
    public $cnpj;
        public $instituicao_financeira_id;
    public $observacoes;

    public $showForm;
    public $alert;

    protected $listeners = ['abrirCreateAgenciaModal'];

    protected $rules = [
        'nome' => 'required|string|min:5|max:255',
        'codigo' => 'required',
        'cnpj' => 'required|cnpj',
    ];

    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function render()
    {
        $instituicoesFinanceiras = InstituicaoFinanceira::where('status', StatusPadraoEnum::ATIVO)->get();

        return view('livewire.agencia-financeira.create-agencia-modal', compact('instituicoesFinanceiras'));
    }

    public function abrirCreateAgenciaModal(): void
    {
        $this->reset();
        $this->alert = [];
        $this->showForm = true;
    }

    public function submit() : void
    {
        $this->validate();

        sleep(1);

        $this->storeAgencia();
    }

    private function storeAgencia()
    {
        try {

            DB::beginTransaction();

            $prestador_id = Session::get('prestador')->id;

            $agencia = AgenciasFinanceiras::create([
                'nome'                          => $this->nome,
                'codigo'                        => $this->codigo,
                'cnpj'                          => $this->cnpj,
                'observacoes'                   => $this->observacoes,
                'status'                        => StatusPadraoEnum::ATIVO,
                'instituicao_financeira_id'     => $this->instituicao_financeira_id,
                'instituicao_id'                => Session::get('instituicao')->id,
                'prestador_id'                  => $prestador_id,
            ]);

            Log::info("Agência Financeira cadastrada pelo Prestador de id {$prestador_id}", $agencia->toArray());

            DB::commit();

            $this->showForm = false;

            $this->alert = [
                'show' => true,
                'type' => 'success',
                'title' => 'Sucesso!',
                'description' => "Agência {$agencia->nome} Cadastrada com sucesso."
            ];

            $this->emitTo('agencia-financeira.agencia-index', '$refresh');

        } catch (Exception $exception) {
            DB::rollBack();
            Log::error("Cadastrando Agência Financeira: " .$exception->getMessage());

            $this->alert = [
                'show' => true,
                'type' => 'danger',
                'title' => 'Erro!',
                'description' => "Houve um problema durante o procedimento e não foi possível cadastrar a agência {$this->nome}."
            ];
        }
    }
}
