<?php

namespace App\Http\Controllers\InstituicaoFinanceira;

use App\Events\PrestadorInsituicaoTenantIdEvent;
use App\Http\Controllers\Controller;
use App\Listeners\SetPrestadorTenantIdInSessionListener;
use App\Models\Instituicao;
use App\Models\Prestador;
use Exception;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;

class AutenticadorInstituicaoFinanceiraController extends Controller
{
    /**
     * @param string $cnpjInstituicaoEPrestadorIdBase64
     * @return RedirectResponse
     */
    public function __invoke(string $cnpjInstituicaoEPrestadorIdBase64) : RedirectResponse
    {
        try {

            $cnpjInstituicaoEPrestadorId64 = explode("@", $cnpjInstituicaoEPrestadorIdBase64);

            if (count($cnpjInstituicaoEPrestadorId64) < 2) {
                return redirect()->route('instituicaoFinanceira.error-feedback');
            }

            [$cnpjInstituicao64, $prestadorId64] = $cnpjInstituicaoEPrestadorId64;

            $cnpjInstituicao    = base64_decode($cnpjInstituicao64);
            $prestadorId        = base64_decode($prestadorId64);

            $instituicao = Instituicao::where('cnpj', $cnpjInstituicao)->first();
            $prestador = Prestador::with('dadosCadastrais')->find($prestadorId);

//            dd("opsps", $cnpjInstituicao, $prestador);

            if (!$instituicao || !$prestador) {
                return redirect()->route('instituicaoFinanceira.error-feedback');
            }

            PrestadorInsituicaoTenantIdEvent::dispatch(
                $instituicao,
                $prestador
            );

            return redirect()->route('instituicaoFinanceira.index');

        } catch (Exception $exception) {

            Log::error("AutenticadorInstituicaoFinanceiraController::class -> " . $exception->getMessage());

            return redirect()->route('instituicaoFinanceira.error-feedback');
        }
    }
}
