<?php

namespace App\Enums;

use BenSampo\Enum\Enum;

final class UfEnum extends Enum
{
    const RO = 1;
    const AC = 2;
    const AM = 3;
    const RR = 4;
    const PA = 5;
    const AP = 6;
    const TO = 7;
    const MA = 8;
    const PI = 9;
    const CE = 10;
    const RN = 11;
    const PB = 12;
    const PE = 13;
    const AL = 14;
    const SE = 15;
    const BA = 16;
    const MG = 17;
    const ES = 18;
    const RJ = 19;
    const SP = 20;
    const PR = 21;
    const SC = 22;
    const RS = 23;
    const MS = 24;
    const MT = 25;
    const GO = 26;
    const DF = 27;

    public static function getDescription($value): string
    {

        if ($value === self::AC) {
            return 'Acre';
        }

        if ($value === self::AL) {
            return 'Alagoas';
        }

        if ($value === self::AP) {
            return 'Amapá';
        }

        if ($value === self::AM) {
            return 'Amazonas';
        }

        if ($value === self::BA) {
            return 'Bahia';
        }

        if ($value === self::CE) {
            return 'Ceará';
        }

        if ($value === self::DF) {
            return 'Distrito Federal';
        }

        if ($value === self::ES) {
            return 'Espírito Santo';
        }

        if ($value === self::GO) {
            return 'Goiás';
        }

        if ($value === self::MA) {
            return 'Maranhão';
        }

        if ($value === self::MT) {
            return 'Mato Grosso';
        }

        if ($value === self::MS) {
            return 'Mato Grosso do Sul';
        }

        if ($value === self::MG) {
            return 'Minas Gerais';
        }

        if ($value === self::PA) {
            return 'Pará';
        }

        if ($value === self::PB) {
            return 'Paraíba';
        }

        if ($value === self::PR) {
            return 'Paraná';
        }

        if ($value === self::PE) {
            return 'Pernambuco';
        }

        if ($value === self::PI) {
            return 'Piauí';
        }

        if ($value === self::RJ) {
            return 'Rio de Janeiro';
        }


        if ($value === self::RN) {
            return 'Rio Grande do Norte';
        }

        if ($value === self::RS) {
            return 'Rio Grande do Sul';
        }


        if ($value === self::RO) {
            return 'Rondônia';
        }

        if ($value === self::RR) {
            return 'Roraima';
        }

        if ($value === self::SC) {
            return 'Santa Catarina';
        }

        if ($value === self::SP) {
            return 'São Paulo';
        }

        if ($value === self::SE) {
            return 'Sergipe';
        }

        if ($value === self::TO) {
            return 'Tocantins';
        }

        return parent::getDescription($value);

    }
}
