<?php

namespace App\Enums;

use BenSampo\Enum\Enum;

/**
 * @method static static OptionOne()
 * @method static static OptionTwo()
 * @method static static OptionThree()
 */
final class TipoPessoaTomador extends Enum
{
    const PESSOA_FISICA =   1;
    const PESSOA_JURIDICA =   2;

    public static function getDescription($value): string
    {
        if ($value === self::PESSOA_FISICA) {
            return 'Pessoa Física';
        }

        if ($value === self::PESSOA_JURIDICA) {
            return 'Pessoa Jurídica';
        }

        return parent::getDescription($value);
    }
}
