<?php declare(strict_types=1);

namespace App\Enums;

use BenSampo\Enum\Enum;
final class StatusPadraoEnum extends Enum
{
    const ATIVO = 1; // green
    const INATIVO = 0; // red

    public static function getDescription($value): string
    {
        if ($value === self::ATIVO) {
            return 'Ativo';
        }

        if ($value === self::INATIVO) {
            return 'Inativo';
        }

        return parent::getDescription($value);
    }
}
