<?php

namespace App\Enums;

use BenSampo\Enum\Enum;

final class SituacaoEnum extends Enum
{
    const REGULAR =   1;
    const CANCELADO =   3;
    const PAGO =   5;

    public static function getDescription($value): string
    {
        if ($value === self::REGULAR) {
            return 'Regular';
        }

        if ($value === self::CANCELADO) {
            return 'Cancelado';
        }

        if ($value === self::PAGO) {
            return 'Pago';
        }

        return parent::getDescription($value);
    }
}
