<?php

namespace App\Enums;

enum MesEnum : int
{
    case JAN = 1;
    case FEV = 2;
    case MAR = 3;
    case ABR = 4;
    case MAI = 5;
    case JUN = 6;
    case JUL = 7;
    case AGO = 8;
    case SET = 9;
    case OUT = 10;
    case NOV = 11;
    case DEZ = 12;

    public function label() : string
    {
        return match ($this) {
            MesEnum::JAN => 'Janeiro',
            MesEnum::FEV => 'Fevereiro',
            MesEnum::MAR => 'Março',
            MesEnum::ABR => 'Abril',
            MesEnum::MAI => 'Maio',
            MesEnum::JUN => 'Junho',
            MesEnum::JUL => 'Julho',
            MesEnum::AGO => 'Agosto',
            MesEnum::SET => 'Setembro',
            MesEnum::OUT => 'Outubro',
            MesEnum::NOV => 'Novembro',
            MesEnum::DEZ => 'Dezembro',
        };
    }
}
