

<div class="mt-3">

    <div class="col-12 mt-3 mb-3 text-center" style="color: #536c79">
        <div class="mt-2">
            <h2><b>CONSULTA NOTAS</b></h2>
        </div>
    </div>

    <div class="card">
        <div class="card-header font-semibold text-center">
            <?php echo e(__('FILTROS')); ?>

        </div>

        <?php if(session()->has('message')): ?>
            <div class="alert alert-danger">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <i class="material-icons">close</i>
                </button>
                <span>
                <?php echo e(session('message')); ?></span>
            </div>
        <?php endif; ?>

        <br>
        <div>
            <nav class="navbar navbar-light bg-light">
                

                <div class="col-sm-12 col-md-4">
                    <label>Tomador</label>
                    <input wire:model="tomador"
                           class="form-control" aria-label="Pesquisar"
                           id="search" type="search" placeholder=""/>
                </div>

                <div class="col-sm-12 col-md-4">
                    <label>A partir de:</label>
                    <input wire:model="inicio" type="date" class="form-control" id="inicio" placeholder="">
                </div>

                <div class="col-sm-12 col-md-4">
                    <label>Até:</label>
                    <input wire:model="fim" type="date" class="form-control" id="dim" placeholder="">
                </div>

                <div class="col-sm-12 col-md-4 offset-md-4 mt-4">
                    <button wire:click="pesquisar" type="button" class=" btn-block btn-primary">Pesquisar</button>
                    <button onclick="imprimir()" type="button" class=" btn-block btn-success">Imprimir</button>
                </div>
                
            </nav>
            
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="text-dark">
                            <tr>
                                <th class="text-center">RESULTADO</th>
                            </tr>
                        </thead>
                        <tbody wire:loading.remove>
                            <?php if(session()->has('message')): ?>
                            <div class="alert alert-danger">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <i class="material-icons">close</i>
                                </button>
                                <span>
                                    <?php echo e(session('message')); ?></span>
                                </div>
                                <?php endif; ?>                            
                            </tbody>
                    </table>
                </div>
            </div>
                
        </div>
    </div>

    <div class="row justify-content-center">
        <div wire:loading class='justify-content-center'>
            CARREGANDO...
        </div>
    </div>

    <table class="table" style="font-size: 12px">
        <thead class="thead-dark">
        <tr>
            <th scope="col">Número</th>
            <th scope="col">Data</th>
            <th scope="col">Situação</th>
            <th scope="col">Tomador</th>
            <th scope="col">Tomador CNPJ/CPF</th>
            <th scope="col">Discriminação</th>
            <th scope="col">Valor Total</th>
            <th scope="col">Valor Acréscimos</th>
            <th scope="col">Aliq ISS</th>
            <th scope="col">Iss Retido</th>
            <th scope="col">Aliq IRRF</th>
            <th scope="col">Valor Irrf</th>
            <th scope="col">Valor Deduções</th>
            <th scope="col">Valor Liquido</th>
            <th scope="col">Opções</th>
            
        </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $searchResult; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <th scope="row"><?php echo e($result->numero); ?></th>
                        <td><?php echo e(date("d/m/Y", strtotime($result->datahoraemissao))); ?></td>
                        <?php if($result->estado=='Cancelada'): ?>
                            <td style="color: red"><?php echo e($result->estado); ?></td>
                        <?php else: ?> 
                            <td><?php echo e($result->estado); ?></td>
                        <?php endif; ?>
                        <td><?php echo e($result->tomador_nome); ?></td>
                        <td><?php echo e($result->tomador_cnpjcpf); ?></td>
                        <td><?php echo e($result->discriminacao); ?></td>
                        <td><?php echo e(number_format($result->valortotal,2,",",".")); ?></td>
                        <td><?php echo e(number_format($result->valoracrescimos,2,",",".")); ?></td>
                        <td><?php echo e(number_format($result->aliq_percentual,2,",",".")); ?></td>
                        <td><?php echo e(number_format($result->issretido,2,",",".")); ?></td>
                        <td><?php echo e(number_format($result->aliqirrf,2,",",".")); ?></td>
                        <td><?php echo e(number_format($result->valorirrf,2,",",".")); ?></td>
                        <td><?php echo e(number_format($result->valordeducoes,2,",",".")); ?></td>
                        <td><?php echo e(number_format($result->total_retencao,2,",",".")); ?></td>
                        
                        <td><a href="<?php echo e(route('exibeNota', ['numero' => $result->numero])); ?>" target=“_blank”><u>Visualizar</u></a></td>
                        
                        
                    </tr>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr class="px-4 py-4">
                    <td class="text-gray-300">
                        Nenhum resultado encontrado
                    </td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div class="row ml-3 font-weight-bold">
        Valor Total: <?php echo e(number_format($valortotal,2,",",".")); ?>

    </div>
    <div class="row ml-3 font-weight-bold">
        Total ISS: <?php echo e(number_format($totaliss,2,",",".")); ?>

    </div>
    <div class="row ml-3 font-weight-bold">
        Total IRRF: <?php echo e(number_format($totalirrf,2,",",".")); ?>

    </div>

    

</div>



<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Nota Fiscal</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div wire:model='searchResult' class="modal-body">

            

            <?php if(isset($searchResult[0])): ?>
                <div class="row">
                    <div class="mt-2 col-3">
                        <label>Número:</label>
                        <input value="<?php echo e($searchResult[$indice]->numero); ?>" disabled class="form-control form-control-sm" type="text">
                    </div>
                    <div class="mt-2 col-3">
                        <label>Código de Verificação:</label>
                        <input value="<?php echo e($searchResult[$indice]->codVerificacao); ?>" disabled class="form-control form-control-sm" type="text">
                    </div>
                    <div class="mt-2 col-3">
                        <label>Data:</label>
                        <input value="<?php echo e(date("d/m/Y", strtotime($searchResult[$indice]->datahoraemissao))); ?>" disabled class="form-control form-control-sm" type="text">
                    </div>
                    <div class="mt-2 col-3">
                        <label>Situação:</label>
                        <input value="<?php echo e($searchResult[$indice]->estado); ?>" disabled class="form-control form-control-sm" type="text">
                    </div>                    
                    <div class="mt-2 col-8">
                        <label>Tomador:</label>
                        <input value="<?php echo e($searchResult[$indice]->tomador_nome); ?>" disabled class="form-control form-control-sm" type="text">
                    </div>
                    <div class="mt-2 col-4">
                        <label>CNPJ/CPF (Tomador):</label>
                        <input value="<?php echo e($searchResult[$indice]->tomador_cnpjcpf); ?>" disabled class="form-control form-control-sm" type="text">
                    </div>
                    <div class="mt-2 col-4">
                        <label>Inscrição Municipal (Tomador):</label>
                        <input value="<?php echo e($searchResult[$indice]->tomador_inscrmunicipal); ?>" disabled class="form-control form-control-sm" type="text">
                    </div>
                    <div class="mt-2 col-4">
                        <label>Inscrição Estadual (Tomador):</label>
                        <input value="<?php echo e($searchResult[$indice]->tomador_inscrestadual); ?>" disabled class="form-control form-control-sm" type="text">
                    </div>
                    <div class="mt-2 col-4">
                        <label>Município (Tomador):</label>
                        <input value="<?php echo e($searchResult[$indice]->tomador_municipio); ?>" disabled class="form-control form-control-sm" type="text">
                    </div>
                    <div class="mt-2 col-8">
                        <label>Prestador:</label>
                        <input value="<?php echo e($searchResult[$indice]->razaosocial); ?>" disabled class="form-control form-control-sm" type="text">
                    </div>
                    <div class="mt-2 col-4">
                        <label>CNPJ/CPF (Prestador):</label>
                        <input value="<?php echo e($searchResult[$indice]->cnpj); ?>" disabled class="form-control form-control-sm" type="text">
                    </div>
                    <div class="mt-2 col-4">
                        <label>Inscrição Municipal (Prestador):</label>
                        <input value="<?php echo e($searchResult[$indice]->inscrmunicipal); ?>" disabled class="form-control form-control-sm" type="text">
                    </div>
                    <div class="mt-2 col-4">
                        <label>Inscrição Estadual (Prestador):</label>
                        <input value="<?php echo e($searchResult[$indice]->inscrestadual); ?>" disabled class="form-control form-control-sm" type="text">
                    </div>
                    <div class="mt-2 col-4">
                        <label>Município (Prestador):</label>
                        <input value="<?php echo e($searchResult[$indice]->municipio); ?>" disabled class="form-control form-control-sm" type="text">
                    </div>
                    <div class="mt-2 col-4">
                        <label>Valor Total:</label>
                        <input value="<?php echo e(number_format($searchResult[$indice]->valortotal,2,",",".")); ?>" disabled class="form-control form-control-sm" type="text">
                    </div>
                    <div class="mt-2 col-4">
                        <label>Valor Deduções:</label>
                        <input value="<?php echo e(number_format($searchResult[$indice]->valordeducoes,2,",",".")); ?>" disabled class="form-control form-control-sm" type="text">
                    </div>
                    <div class="mt-2 col-4">
                        <label>Valor Acréscimos:</label>
                        <input value="<?php echo e(number_format($searchResult[$indice]->valoracrescimos,2,",",".")); ?>" disabled class="form-control form-control-sm" type="text">
                    </div>
                    <div class="mt-2 col-4">
                        <label>ISS Retido:</label>
                        <input value="<?php echo e(number_format($searchResult[$indice]->issretido,2,",",".")); ?>" disabled class="form-control form-control-sm" type="text">
                    </div>
                    <div class="mt-2 col-4">
                        <label>Valor INSS:</label>
                        <input value="<?php echo e(number_format($searchResult[$indice]->valorinss,2,",",".")); ?>" disabled class="form-control form-control-sm" type="text">
                    </div>
                    <div class="mt-2 col-4">
                        <label>Alíquota ISS:</label>
                        <input value="<?php echo e(number_format($searchResult[$indice]->aliq_percentual,2,",",".")); ?>" disabled class="form-control form-control-sm" type="text">
                    </div>
                    <div class="mt-2 col-12">
                        <label>Discriminação:</label>
                        <textarea value="<?php echo e($searchResult[$indice]->discriminacao); ?>" disabled class="form-control form-control-sm" type="text"></textarea>
                    </div>
                    <div class="mt-2 col-12">
                        <label>Motivo do Cancelamento:</label>
                        <textarea value="<?php echo e($searchResult[$indice]->motivo_cancelamento); ?>" disabled class="form-control form-control-sm" type="text"></textarea>
                    </div>
                    <div class="mt-2 col-12">
                        <label>Observação:</label>
                        <textarea value="<?php echo e($searchResult[$indice]->observacao); ?>" disabled class="form-control form-control-sm" type="text"></textarea>
                    </div>
                </div>
            <?php endif; ?>    
        </div>
      </div>
    </div>
  </div>

<script>
    function imprimir(){
        window.print();
    }
</script><?php /**PATH /home/eticon/public_html/consultanotas/resources/views/livewire/instituicao/selecao.blade.php ENDPATH**/ ?>