<?php

use App\Http\Controllers\PDFController;
use Illuminate\Support\Facades\Route;
use App\Models\Instituicao;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return redirect()->route('consulta');
})->name('home');

Route::get('/autenticacao/{cnpj}', function ($cnpj) {
        session()->put('prestador', $cnpj);
        return redirect()->route('consulta');
})->name('autenticacao');

// ROTA PARA GRAVAR A INSTITUICAO SELECIONADA NA SESSAO
Route::get('/instituicao/{cnpj}', function ($cnpj) {
    $instituicao = Instituicao::where('cnpj', $cnpj)->first(['nome', 'cnpj', 'link_nfe']);

    if (isset($instituicao)){
        session()->put('instituicao', $instituicao);
        return redirect()->route('home');
    }else{
        return redirect()->route('selecao');
    }
})->name('autenticacao2');

//BOLETO
// Route::get('/boleto/{id}', function ($id) {
//     return view('livewire.boleto.show', ['idFinanceiro' => $id]);
// })->name('boleto');

Route::get('/nota/{numero}', function ($numero) {
    return view('livewire.boleto.show', ['numero' => $numero]);
})->name('exibeNota');

//IPTU
Route::view('iptu','livewire.iptu.show')->name('iptu');
//->middleware('checkInstituicao');

//ITBI
Route::view('itbi','livewire.itbi.show')->name('itbi');

//VALIDAR NFS-e
Route::view('validar-nfse','livewire.nota-fiscal.show')->name('validar-nfse');

//VALIDAR ALVARÁ DE FUNCIONAMENTO
Route::view('validar-alvara-funcionamento','livewire.alvara-funcionamento.show')->name('validar-alvara-funcionamento');

//VALIDAR NFS-e (Link com QR Code)
Route::get('validar-nfse-qr/{cnpj}/{codigo}', function ($cnpj, $codigo) {
    $instituicao = Instituicao::where('cnpj', $cnpj)->first(['nome', 'cnpj', 'link_nfe']);

    if (isset($instituicao)){
        session()->put('instituicao', $instituicao);
        return view('livewire.nota-fiscal-qr.show', ['empresa' => $cnpj, 'codigo' => $codigo ]);
    }else{
        return redirect()->route('selecao');
    }
});

//CERTIDÃO NEGATIVA
Route::view('certidao','livewire.certidao.show')->name('certidao');

//NEGOCIAÇÃO DE DÍVIDA
Route::view('negociacao','livewire.negociacao-divida.show')->name('negociacao');

//VALIDAÇÃO CERTIDÃO NEGATIVA
Route::view('validacao','livewire.validacao.show')->name('validacao');

// SELEÇÃO DE INSTITUIÇÃO
Route::view('consulta','livewire.instituicao.show')->name('consulta');

// PDF CERTIDÃO NEGATIVA
Route::get('certidao-pdf', [PDFController::class, 'index'])->name('certidao-pdf');

// PDF TRANSFERÊNCIA IMÓVEL
Route::get('transferencia-pdf', [PDFController::class, 'transferencia'])->name('transferencia-pdf');

// PDF ITBI
Route::get('itbi-pdf', [PDFController::class, 'itbi'])->name('itbi-pdf');
