<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') }}</title>

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Nunito:400,600,700" rel="stylesheet">

    <!-- Styles -->
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">

    @livewireStyles

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/gh/alpinejs/alpine@v2.6.0/dist/alpine.js" defer></script>
</head>
<body class="font-sans antialiased">
<div class="min-h-screen bg-gray-100">

    <!-- Page Heading -->
    <header class="bg-white shadow">
        <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
        </div>
    </header>

    <!-- Page Content -->
    <main>

        <div class="row">
            <div class="col-sm-8 offset-sm-2">
                <h1 class="display-3">Update a Estabelecimento</h1>
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    <br/>
                @endif
                <form method="post" action="{{ route('estabelecimentos.update', $estabelecimento->id) }}">
                    @method('PATCH')
                    @csrf
                    <div class="form-group">
                        <label for="first_name">Nome do Estabelecimento:</label>
                        <input type="text" class="form-control" name="nome" value={{ $estabelecimento->nome }} />
                    </div>


                    <div class="form-group">
                        <label for="gestor">Gestor:</label>
                        <select name="gestor" id="gestor">
                            @foreach($usuarios as $usuario)
                                @if($usuario->id === $estabelecimento->gestor->id)
                                    <option selected value="{{$usuario->id}}">{{$usuario->name}} - {{ $usuario->id }}</option>
                                @else
                                    <option value="{{$usuario->id}}">{{$usuario->name}} - {{ $usuario->id }}</option>
                                @endif
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="usuarios">Usuários:</label>
                        <select name="usuarios[]" id="usuarios" multiple data-live-search="true">
                            @foreach($usuarios as $usuario)
                                <option value="{{$usuario->id}}">{{$usuario->name}} - {{ $usuario->id }}</option>
                            @endforeach
                        </select>
                    </div>


                    <button type="submit" class="btn btn-primary">Atualizar</button>
                </form>
            </div>
        </div>

    </main>
</div>

@stack('modals')

@livewireScripts
</body>
</html>

