<x-template>
    @section('content')

    <h2>Basic Form Elements</h2>
    <br />
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-primary" data-collapsed="0">
                <div class="panel-heading">
                    <h1>{{ __('CADASTRO DE ESTABELECIMENTO') }}</h1>
            
                </div>
                <div class="panel-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div><br/>
                    @endif

                    <form role="form" class="form-horizontal form-groups-bordered" method="post" action="{{ route('estabelecimentos.store') }}">
                        @csrf
                        <div class="form-group">
                            <label for="nome" class="col-sm-3 control-label">Nome do Estabelecimento:</label>
                            <input type="text" class="form-control" name="nome"/>
                        </div>

                        <div class="form-group">
                            <label for="gestor" class="col-sm-3 control-label">Gestor:</label>
                            <select name="gestor" id="gestor">
                                @foreach($usuarios as $usuario)
                                    <option value="{{$usuario->id}}">{{$usuario->name}} - {{ $usuario->id }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="usuarios" class="col-sm-3 control-label">Usuários:</label>
                            <select name="usuarios[]" id="usuarios" multiple data-live-search="true">
                                @foreach($usuarios as $usuario)
                                    <option value="{{$usuario->id}}">{{$usuario->name}} - {{ $usuario->id }}</option>
                                @endforeach
                            </select>
                        </div>

                        <button type="submit" class="btn btn-default">Criar</button>
                    </form>

                </div>
            </div>
        </div>
    </div><hr />

    @endsection
</x-template>

