

    const Instituicoes = sequelize.define("instituicoes", {
        id: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            autoIncrement: true
        },
        nome: {
            type: DataTypes.STRING(150),
            allowNull: false,
            unique: true
        },
        cnpj: {
            type: DataTypes.STRING(14),
            allowNull: false,
            unique: true
        },
        password: {
            type: DataTypes.STRING(200),
            defaultValue: ''
        },
        codigo_barras: {
            type: DataTypes.INTEGER,
            defaultValue: 0
        },
        admin: {
            type: DataTypes.INTEGER,
            defaultValue: 0
        }
    });

    const Imoveis = sequelize.define("imoveis",
        {
            codigoimoveis: {
                type: DataTypes.INTEGER,
                primaryKey: true
            },
            empresa: {
                type: DataTypes.STRING(14),
                primaryKey: true,
                allowNull: false
            },
            cnpj_cpf: {
                type: DataTypes.STRING(14),
                defaultValue: ""
            },
            inscricao: {
                type: DataTypes.STRING(150),
                defaultValue: ""
            },
            endereco: {
                type: DataTypes.STRING(200),
                defaultValue: ""
            },
            distrito: {
                type: DataTypes.STRING(150),
                defaultValue: ""
            },
            setor: {
                type: DataTypes.STRING(150),
                defaultValue: ""
            },
            quadra: {
                type: DataTypes.STRING(150),
                defaultValue: ""
            },
            lote: {
                type: DataTypes.STRING(150),
                defaultValue: ""
            },
            unidade: {
                type: DataTypes.STRING(150),
                defaultValue: ""
            },
            cidade: {
                type: DataTypes.STRING(150),
                defaultValue: ""
            },
            uf: {
                type: DataTypes.STRING(150),
                defaultValue: ""
            },
            bairro: {
                type: DataTypes.STRING(150),
                defaultValue: ""
            },
            areaterreno: {
                type: DataTypes.DOUBLE,
                defaultValue: 0
            },
            areaconstruida: {
                type: DataTypes.DOUBLE,
                defaultValue: 0
            },
            valorvenal: {
                type: DataTypes.DOUBLE,
                defaultValue: 0
            },
            aliquotaiptu: {
                type: DataTypes.DOUBLE,
                defaultValue: 0
            },
            valoriptu: {
                type: DataTypes.DOUBLE,
                defaultValue: 0
            },
            taxalixo: {
                type: DataTypes.DOUBLE,
                defaultValue: 0
            },
        },
        {
            indexes: [
                {
                    unique: true,
                    fields: ['inscricao', 'empresa']
                }
            ]
        }
    );

    const Fornecedores = sequelize.define("fornecedores",
        {
            nome: {
                type: DataTypes.STRING(100),
                defaultValue: ""
            },
            cnpj_cpf: {
                type: DataTypes.STRING(14),
                primaryKey: true,
                allowNull: false
            },
            empresa: {
                type: DataTypes.STRING(14),
                primaryKey: true,
                allowNull: false
            },
            tipopessoa: {
                type: DataTypes.INTEGER,
                allowNull: false
            },
            endereco: {
                type: DataTypes.STRING(120),
                defaultValue: ""
            },
            numero: {
                type: DataTypes.STRING(10),
                defaultValue: ""
            },
            complemento: {
                type: DataTypes.STRING(50),
                defaultValue: ""
            },
            cep: {
                type: DataTypes.STRING(50),
                defaultValue: ""
            },
            bairro: {
                type: DataTypes.STRING(100),
                defaultValue: ""
            },
            cidade: {
                type: DataTypes.STRING(100),
                defaultValue: ""
            },
            uf: {
                type: DataTypes.STRING(2),
                defaultValue: ""
            },
            fone: {
                type: DataTypes.STRING(100),
                defaultValue: ""
            },
            inscestadual: {
                type: DataTypes.STRING(100),
                defaultValue: ""
            },
            inscmunicipal: {
                type: DataTypes.STRING(100),
                defaultValue: ""
            },
            mei: {
                type: DataTypes.INTEGER,
                defaultValue: 0
            },
            email: {
                type: DataTypes.STRING(50),
                defaultValue: ""
            },
            devedor: {
                type: DataTypes.INTEGER,
                defaultValue: 0
            }
        },
        {
            indexes: [
                {
                    unique: true,
                    fields: ['cnpj_cpf', 'empresa']
                }
            ]
        }
    );


    const Financeiros = sequelize.define("financeiros", {
        idfinanceiro: {
            type: DataTypes.INTEGER,
            primaryKey: true,
            allowNull: false
        },
        empresa: {
            type: DataTypes.STRING(14),
            primaryKey: true,
            allowNull: false
        },
        cnpj_cpf: {
            type: DataTypes.STRING(14),
            allowNull: false
        },
        data: {
            type: DataTypes.DATEONLY,
            allowNull: false
        },
        vencimento: {
            type: DataTypes.DATEONLY,
            allowNull: false
        },
        documento: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        descricao: {
            type: DataTypes.STRING,
            defaultValue: ""
        },
        valor: {
            type: DataTypes.DOUBLE,
            allowNull: false
        },
        situacao: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        exercicio: {
            type: DataTypes.STRING(4),
            allowNull: false
        },
        codigobarra: {
            type: DataTypes.STRING,
            allowNull: false
        },
        nossonumero: {
            type: DataTypes.STRING(100),
            defaultValue: ""
        },
        contareceita: {
            type: DataTypes.STRING(100),
            defaultValue: ""
        },
        cb_codigobanco: {
            type: DataTypes.STRING(20),
            defaultValue: ""
        },
        cb_agencia: {
            type: DataTypes.STRING(20),
            defaultValue: ""
        },
        cb_dgagencia: {
            type: DataTypes.STRING(20),
            defaultValue: ""
        },
        cb_contabancaria: {
            type: DataTypes.STRING(100),
            defaultValue: ""
        },
        cb_dgcontabancaria: {
            type: DataTypes.STRING(20),
            defaultValue: ""
        },
        cb_descricaocontabancaria: {
            type: DataTypes.STRING(100),
            defaultValue: ""
        },
        valor_pago: {
            type: DataTypes.DOUBLE,
            defaultValue: 0
        },
        juros: {
            type: DataTypes.DOUBLE,
            defaultValue: 0
        },
        multa: {
            type: DataTypes.DOUBLE,
            defaultValue: 0
        },
        desconto: {
            type: DataTypes.DOUBLE,
            defaultValue: 0
        },
        avulso: {
            type: DataTypes.INTEGER,
            defaultValue: 0
        },
        tipotributo: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        codigotributo: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        historico: {
            type: DataTypes.TEXT,
            defaultValue: ""
        },
        numeroparcela: {
            type: DataTypes.INTEGER,
            allowNull: false
        },
        dtpagamento: {
            type: DataTypes.DATEONLY,
            allowNull: true
        },

    });



