<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateItbisTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('itbis', function (Blueprint $table) {
            $table->id();

            $table->integer('imovel')->nullable();
            $table->string('empresa')->nullable();
            $table->string('transmitente')->nullable();
            $table->string('comprador')->nullable();
            $table->string('dataLancamento')->nullable();
            $table->string('dataTransacao')->nullable();
            $table->double('valorVenal')->nullable();
            $table->double('valorInstrumento')->nullable();
            $table->double('parteFinanciada')->nullable();
            $table->double('parteNaoFinanciada')->nullable();
            $table->double('aliquota')->nullable();
            $table->string('naturezaTransacao')->nullable();
            $table->string('observacoes')->nullable();
            $table->string('exercicio')->nullable();
            $table->string('usuario')->nullable();
            $table->string('situacao')->nullable();

            $table->string('inscricao_imovel')->nullable();
            $table->string('inscricao_endereco')->nullable();
            $table->string('inscricao_numero')->nullable();
            $table->string('inscricao_bairro')->nullable();
            $table->string('inscricao_cidade')->nullable();
            $table->string('inscricao_uf')->nullable();

            $table->string('transmitente_endereco')->nullable();
            $table->string('transmitente_numero')->nullable();
            $table->string('transmitente_bairro')->nullable();
            $table->string('transmitente_cidade')->nullable();
            $table->string('transmitente_uf')->nullable();

            $table->string('comprador_endereco')->nullable();
            $table->string('comprador_numero')->nullable();
            $table->string('comprador_bairro')->nullable();
            $table->string('comprador_cidade')->nullable();
            $table->string('comprador_uf')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('itbis');
    }
}
