<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFinanceirosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('financeiros', function (Blueprint $table) {
            $table->id();
            $table->integer('idfinanceiro')->nullable();
            $table->string('cnpj_cpf')->nullable();
            $table->date('data')->nullable();
            $table->date('vencimento')->nullable();
            $table->integer('documento')->nullable();
            $table->integer('tipotributo')->nullable();
            $table->integer('codigotributo')->nullable();
            $table->text('historico')->nullable();
            $table->integer('numeroparcela')->nullable();
            $table->string('descricao')->nullable();
            $table->double('valor')->nullable();
            $table->integer('situacao')->nullable();
            $table->string('exercicio')->nullable();
            $table->string('empresa')->nullable();
            $table->string('codigobarra')->nullable();
            $table->string('nossonumero')->nullable();
            $table->string('contareceita')->nullable();
            $table->string('cb_codigobanco')->nullable();
            $table->string('cb_agencia')->nullable();
            $table->string('cb_dgagencia')->nullable();
            $table->string('cb_contabancaria')->nullable();
            $table->string('cb_dgcontabancaria')->nullable();
            $table->string('cb_descricaocontabancaria')->nullable();
            $table->double('valor_pago')->nullable();
            $table->double('juros')->nullable();
            $table->double('multa')->nullable();
            $table->double('desconto')->nullable();
            $table->date('dtpagamento')->nullable();
            $table->string('linhadigitavel')->nullable();


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('financeiros');
    }
}
