<?php

namespace Database\Factories;

use App\Models\Fornecedor;
use App\Models\Instituicao;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class FornecedorFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Fornecedor::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'nome' => $this->faker->name,
            'cnpj_cpf' => Instituicao::inRandomOrder()->first()->cnpj,
            'empresa' => $this->faker->company,
            'tipopessoa' => $this->faker->randomNumber(2),
            'endereco' => $this->faker->streetName,
            'numero' => $this->faker->randomNumber(2),
            'complemento' => $this->faker->sentence,
            'cep' => $this->faker->randomNumber(7),
            'bairro' => $this->faker->secondaryAddress,
            'cidade' => $this->faker->city,
            'uf' => $this->faker->state,
            'fone' => $this->faker->phoneNumber,
            'inscestadual' => $this->faker->randomNumber(9),
            'inscmunicipal' => $this->faker->randomNumber(9),
            'email' => $this->faker->companyEmail,
            'mei' => $this->faker->randomNumber(9),
            'devedor' => $this->faker->randomNumber(2),
        ];
    }
}
