<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Imovel extends Model
{
    use HasFactory;

    protected $table = 'imoveis';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'inscricao',
        'codigoimoveis',
        'distrito',
        'setor',
        'quadra',
        'lote',
        'unidade',
        'cnpj_cpf',
        'cidade',
        'uf',
        'bairro',
        'areaterreno',
        'areaconstruida',
        'aliquotaiptu',
        'endereco',
        'valoriptu',
        'valorvenal',
        'taxalixo',
        'empresa'
    ];

    protected $primaryKey = 'id';

    protected $inscricao = 'inscricao';
    protected $codigoimoveis = 'codigoimoveis';
    protected $distrito = 'distrito';
    protected $setor = 'setor';
    protected $quadra = 'quadra';
    protected $lote = 'lote';
    protected $unidade = 'unidade';
    protected $cnpj_cpf = 'cnpj_cpf';
    protected $cidade = 'cidade';
    protected $uf = 'uf';
    protected $bairro = 'bairro';
    protected $areaterreno = 'areaterreno';
    protected $areaconstruida = 'areaconstruida';
    protected $aliquotaiptu = 'aliquotaiptu';
    protected $endereco = 'endereco';
    protected $valoriptu = 'valoriptu';
    protected $valorvenal = 'valorvenal';
    protected $taxalixo = 'taxalixo';
    protected $empresa = 'empresa';

    public function instituicao()
    {
        return $this->belongsTo(Instituicao::class, 'cnpj','cpf_cnpj');
    }

    public function financeiro()
    {
        return $this->hasMany(Financeiro::class, 'cnpj_cpf','cnpj_cpf');
    }
}
