<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Financeiro extends Model
{
    use HasFactory;

    protected $fillable = [
        'idfinanceiro',
        'cnpj_cpf',
        'data',
        'vencimento',
        'documento',
        'tipotributo',
        'codigotributo',
        'historico',
        'numeroparcela',
        'descricao',
        'valor',
        'situacao',
        'exercicio',
        'empresa',
        'codigobarra',
        'nossonumero',
        'contareceita',
        'cb_codigobanco',
        'cb_agencia',
        'cb_dgagencia',
        'cb_contabancaria',
        'cb_dgcontabancaria',
        'cb_descricaocontabancaria',
        'valor_pago',
        'juros',
        'multa',
        'desconto',
        'dtpagamento',
        'linhadigitavel'
    ];

    protected $hidden = [
        'password'
    ];

    protected $table = 'financeiros';
    protected $primaryKey = 'id';

    protected $idfinanceiro = 'idfinanceiro';
    protected $cnpj_cpf = 'cnpj_cpf';
    protected $data = 'data';
    protected $vencimento = 'vencimento';
    protected $documento = 'documento';
    protected $tipotributo = 'tipotributo';
    protected $codigotributo = 'codigotributo';
    protected $historico = 'historico';
    protected $numeroparcela = 'numeroparcela';
    protected $descricao = 'descricao';
    protected $valor = 'valor';
    protected $situacao = 'situacao';
    protected $exercicio = 'exercicio';
    protected $empresa = 'empresa';
    protected $codigobarra = 'codigobarra';
    protected $nossonumero = 'nossonumero';
    protected $contareceita = 'contareceita';
    protected $cb_codigobanco = 'cb_codigobanco';
    protected $cb_agencia = 'cb_agencia';
    protected $cb_dgagencia = 'cb_dgagencia';
    protected $cb_contabancaria = 'cb_contabancaria';
    protected $cb_dgcontabancaria = 'cb_dgcontabancaria';
    protected $cb_descricaocontabancaria = 'cb_descricaocontabancaria';
    protected $valor_pago = 'valor_pago';
    protected $juros = 'juros';
    protected $multa = 'multa';
    protected $desconto = 'desconto';
    protected $dtpagamento = 'dtpagamento';
    protected $linhadigitavel = 'linhadigitavel';

    public function instituicao()
    {
        return $this->belongsTo(Instituicao::class, 'cpf_cnpj','cnpj');
    }
}
