<?php

namespace App\Http\Livewire\Iptu;

use App\Models\Financeiro;
use App\Models\Imovel;
use Livewire\Component;

class Iptu extends Component
{
    public $inscricao = '';
    public $instituicoes = [];
    public $imovel = null;
    public $financeiros = [];

    public function render()
    {
        return view('livewire.iptu.iptu');
    }

    public function find()
    {
        $instituicao_cnpj = session()->get('instituicao')->cnpj;
        
        $this->imovel = Imovel::where('inscricao', '=', $this->inscricao)
            ->where('empresa', '=', $instituicao_cnpj)
            ->first();

        if(!$this->imovel){
            session()->flash('message', 'IMÓVEL NÃO ENCONTRADO');
            return false;
        }

        $this->financeiros = Financeiro::where('tipotributo','=',2)
        ->where('situacao','=',1)
        ->where('documento','=',$this->imovel->codigoimoveis)
        ->where('empresa','=',$this->imovel->empresa)
        ->get();
        
    }    

}
