<?php

namespace App\Http\Livewire\Instituicao;

use App\Models\Instituicao;
use Livewire\Component;
use DB;

class Selecao extends Component
{
    public $search = '';
    public $tomador = '';
    public $inicio = '';
    public $fim = '';
    public $valortotal = 0;
    public $totaliss = 0;
    public $totalirrf = 0;
    public $docprestador = '';
    public $notaSelecionada;
    public $indice = 0;
    public $t;

    public $searchResult = [];

    public function pesquisar()
    {
        $query = "SELECT    n.numero,
                            codVerificacao,
                            datahoraemissao,
                            ns.discriminacao,
                            n.estado,
                            n.tomador_nome,
                            n.tomador_cnpjcpf,
                            n.tomador_inscrmunicipal,
                            n.tomador_inscrestadual,
                            n.tomador_endereco,
                            n.tomador_logradouro,
                            n.tomador_numero,
                            n.tomador_complemento,
                            n.tomador_municipio,
                            n.discriminacao,
                            n.observacao,
                            n.valortotal,
                            n.valordeducoes,
                            n.valoracrescimos,
                            n.basecalculo,
                            n.issretido,
                            n.valorinss,
                            n.valorirrf,
                            n.aliqirrf,
                            n.deducao_irrf,
                            n.total_retencao,
                            n.aliq_percentual,
                            n.motivo_cancelamento,
                            n.tipoemissao,
                            c.nome,
                            c.razaosocial,
                            c.cnpj,
                            c.inscrmunicipal,
                            c.inscrestadual,
                            c.municipio
                    FROM  notas n
                    INNER JOIN notas_servicos ns ON ns.codnota=n.codigo
                    INNER JOIN cadastro c ON c.codigo=n.codemissor 
                    WHERE 1=1";


        if($this->inicio !=''){
            $query= $query." AND datahoraemissao > '". $this->inicio."'";
        }

        if($this->fim !=''){
            $query= $query." AND datahoraemissao < '". $this->fim."'";
        }

        if($this->tomador !=''){
            $query= $query." AND tomador_nome LIKE '%". $this->tomador."%'";
        }

        $this->docprestador = session()->get('prestador');
        $this->docprestador = $this->mask($this->docprestador, '##.###.###/####-##');

        if($this->docprestador !=''){
            $query= $query." AND cnpj = '". $this->docprestador."'";
        }

        $query= $query."LIMIT 3000";

        // if($this->inicio !=''){
        //     dd($query);
        // }


        $this->searchResult = DB::select($query);
        // dd(sizeof($this->searchResult));
        
        $this->valortotal = 0;
        $this->totaliss = 0;
        $this->totalirrf = 0;

        foreach ($this->searchResult as $key => $value) {
            $this->valortotal += $value->valortotal;
            $this->totaliss += $value->issretido;
            $this->totalirrf += $value->valorirrf;
            
            if ($value->estado == 'C'){
                $value->estado = 'Cancelada';
            } else {
                $value->estado = 'Normal';
            }

            $value->indice = $key;
        }
    }

    public function selecionarNota($ind){
       $this->indice = $ind;
       $this->notaSelecionada = $this->searchResult[$ind];

    //    foreach ($this->notaSelecionada as $key => $value) {
    //        $this->t[$key] = $value;
    //    }
    //    dd($this->notaSelecionada['numero']);
    }


    // public function updatedSearch($newValue)
    // {
    //     // $this->searchResult = $this->instituicoes = Instituicao::where('nome', 'ilike', '%' . $newValue . '%')->get();
    //     // $results = [];

    //     $query = "SELECT    n.numero,
    //                         codVerificacao,
    //                         datahoraemissao,
    //                         ns.discriminacao,
    //                         n.estado,
    //                         n.tomador_nome,
    //                         n.tomador_cnpjcpf,
    //                         n.tomador_inscrmunicipal,
    //                         n.tomador_inscrestadual,
    //                         n.tomador_endereco,
    //                         n.tomador_logradouro,
    //                         n.tomador_numero,
    //                         n.tomador_complemento,
    //                         n.tomador_municipio,
    //                         n.discriminacao,
    //                         n.observacao,
    //                         n.valortotal,
    //                         n.valordeducoes,
    //                         n.valoracrescimos,
    //                         n.basecalculo,
    //                         n.issretido,
    //                         n.valorinss,
    //                         n.valorirrf,
    //                         n.aliqirrf,
    //                         n.deducao_irrf,
    //                         n.total_retencao,
    //                         n.aliq_percentual,
    //                         n.motivo_cancelamento,
    //                         n.tipoemissao,
    //                         c.nome,
    //                         c.razaosocial,
    //                         c.cnpj,
    //                         c.inscrmunicipal,
    //                         c.inscrestadual
    //                 FROM  notas n
    //                 INNER JOIN notas_servicos ns ON ns.codnota=n.codigo
    //                 INNER JOIN cadastro c ON c.codigo=n.codemissor";

    //     $this->searchResult = DB::select($query);

       

    // }

    public function render()
    {
        $this->pesquisar();
        return view('livewire.instituicao.selecao');
    }

    public function redirecionar($cnpj)
    {
        return redirect()->route('autenticacao', $cnpj);
    }

    function mask($val, $mask) {
        $maskared = '';
        $k = 0;
        for($i = 0; $i<=strlen($mask)-1; $i++) {
            if($mask[$i] == '#') {
                if(isset($val[$k])) $maskared .= $val[$k++];
            } else {
                if(isset($mask[$i])) $maskared .= $mask[$i];
            }
        }
        return $maskared;
    }
}
