<?php

namespace App\Http\Livewire;

use Livewire\Component;

class Header extends Component
{
    public $cnpj;
    public $nome;
    public $logo;

    public function render()
    {
        $this->nome = isset(session()->get('instituicao')->nome) ? session()->get('instituicao')->nome : '';
        $this->cnpj = isset(session()->get('instituicao')->cnpj) ? session()->get('instituicao')->cnpj : '';
        $this->logo = '//' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']).'/public/images/brasoes/'.$this->cnpj.'.png';
        return view('livewire.header');
    }

    public function mount(){
        if (!session()->has('instituicao'))
            return redirect()->to('/selecao');
    }
}
