<?php

namespace App\Http\Livewire\Boleto;

use App\Models\Financeiro;
use App\Models\Instituicao;
use DateTime;
use Dompdf\Dompdf;
use Livewire\Component;
use OpenBoleto\Agente;
use OpenBoleto\Banco\BancoDoBrasil;
use PDF;
use DB;

class GerarBoleto extends Component
{
    public $searchResult;
    public $nota;
    public $docprestador = '';

    public function render() 
    {
        return view('livewire.boleto.gerar-boleto');
    }

    public function mount($numero){
        // dd($numero);

        $query = "SELECT    n.numero,
                            codVerificacao,
                            datahoraemissao,
                            ns.discriminacao,
                            n.estado,
                            n.tomador_nome,
                            n.tomador_cnpjcpf,
                            n.tomador_inscrmunicipal,
                            n.tomador_inscrestadual,
                            n.tomador_endereco,
                            n.tomador_logradouro,
                            n.tomador_numero,
                            n.tomador_complemento,
                            n.tomador_municipio,
                            n.discriminacao,
                            n.observacao,
                            n.valortotal,
                            n.valordeducoes,
                            n.valoracrescimos,
                            n.basecalculo,
                            n.issretido,
                            n.valorinss,
                            n.valorirrf,
                            n.aliqirrf,
                            n.deducao_irrf,
                            n.total_retencao,
                            n.aliq_percentual,
                            n.motivo_cancelamento,
                            n.tipoemissao,
                            c.nome,
                            c.razaosocial,
                            c.cnpj,
                            c.inscrmunicipal,
                            c.inscrestadual,
                            c.municipio
                    FROM  notas n
                    INNER JOIN notas_servicos ns ON ns.codnota=n.codigo
                    INNER JOIN cadastro c ON c.codigo=n.codemissor
                    WHERE 1=1";

        $query= $query." AND n.numero = '". $numero."'";

        // if($this->inicio !=''){
        //     $query= $query." AND datahoraemissao > '". $this->inicio."'";
        // }

        // if($this->fim !=''){
        //     $query= $query." AND datahoraemissao < '". $this->fim."'";
        // }

        // if($this->tomador !=''){
        //     $query= $query." AND tomador_nome LIKE '%". $this->tomador."%'";
        // }

        $this->docprestador = session()->get('prestador');
        $this->docprestador = $this->mask($this->docprestador, '##.###.###/####-##');

        if($this->docprestador !=''){
            $query= $query." AND cnpj = '". $this->docprestador."'";
        }

        $this->searchResult = DB::select($query);
        // dd(sizeof($this->searchResult));
        
        // $this->valortotal = 0;

        // dd($this->searchResult);

        foreach ($this->searchResult as $key => $value) {
            // $this->valortotal += $value->valortotal;
            
            if ($value->estado == 'C'){
                $value->estado = 'Cancelada';
            } else {
                $value->estado = 'Normal';
            }


            // $value->indice = $key;
        }

        // $this->nota = $this->searchResult[0]->numero;

        echo "<div class='m-2'>";
        
        echo '<b>Número:</b> ';
        echo $this->searchResult[0]->numero;

        echo '<br><b>Código de Verificação: </b>';
        echo $this->searchResult[0]->codVerificacao;

        echo '<br><b>Data: </b>';
        echo date("d/m/Y", strtotime($this->searchResult[0]->datahoraemissao));

        echo '<br><b>Situação:</b>';
        echo $this->searchResult[0]->estado;

        echo '<br><b>Tomador:</b> ';
        echo $this->searchResult[0]->tomador_nome;

        echo '<br><b>CNPJ/CPF (Tomador):</b> ';
        echo $this->searchResult[0]->tomador_cnpjcpf;

        echo '<br><b>Inscrição Municipal (Tomador):</b> ';
        echo $this->searchResult[0]->tomador_inscrmunicipal;

        echo '<br><b>Inscrição Estadual (Tomador):</b> ';
        echo $this->searchResult[0]->tomador_inscrestadual;

        echo '<br><b>Município (Tomador):</b> ';
        echo $this->searchResult[0]->tomador_municipio;

        echo '<br><b>Prestador:</b> ';
        echo $this->searchResult[0]->razaosocial;

        echo '<br><b>CNPJ/CPF (Prestador):</b> ';
        echo $this->searchResult[0]->cnpj;

        echo '<br><b>Inscrição Municipal (Prestador):</b> ';
        echo $this->searchResult[0]->inscrmunicipal;

        echo '<br><b>Inscrição Estadual (Prestador):</b> ';
        echo $this->searchResult[0]->inscrestadual;

        echo '<br><b>Município (Prestador):</b> ';
        echo $this->searchResult[0]->municipio;

        echo '<br><b>Valor Total:</b> ';
        echo number_format($this->searchResult[0]->numero,2,",",".");

        echo '<br><b>Valor Deduções:</b> ';
        echo number_format($this->searchResult[0]->valordeducoes,2,",",".");

        echo '<br><b>Valor Acréscimos:</b> ';
        echo number_format($this->searchResult[0]->valoracrescimos,2,",",".");

        echo '<br><b>ISS Retido:</b> ';
        echo number_format($this->searchResult[0]->issretido,2,",",".");

        echo '<br><b>Valor INSS:</b> ';
        echo number_format($this->searchResult[0]->valorinss,2,",",".");

        echo '<br><b>Alíquota ISS:</b> ';
        echo number_format($this->searchResult[0]->aliq_percentual,2,",",".");

        echo '<br><b>Discriminação:</b> ';
        echo $this->searchResult[0]->discriminacao;

        echo '<br><b>Motivo do Cancelamento:</b> ';
        echo $this->searchResult[0]->motivo_cancelamento;

        echo '<br><b>Observação:</b> ';
        echo $this->searchResult[0]->observacao;

        echo "</div>";


    }

    function mask($val, $mask) {
        $maskared = '';
        $k = 0;
        for($i = 0; $i<=strlen($mask)-1; $i++) {
            if($mask[$i] == '#') {
                if(isset($val[$k])) $maskared .= $val[$k++];
            } else {
                if(isset($mask[$i])) $maskared .= $mask[$i];
            }
        }
        return $maskared;
    }


}
