<?php

namespace App\Http\Livewire\AlvaraFuncionamento;

use App\Models\AlvaraFuncionamento;
use Livewire\Component;

class Validar extends Component
{
    public $empresa, $numero, $validacao;

    public $alvara;

    public function rules()
    {
        return [
            'numero' => 'required|int',
            'validacao' => 'required|numeric',
        ];
    }

    public function find()
    {
        $this->validate();

        $instituicao_cnpj = session()->get('instituicao')->cnpj;

        $this->alvara = AlvaraFuncionamento::where('numero', $this->numero)
            ->where('validacao', $this->validacao)
            ->where('empresa', $instituicao_cnpj)->first();

        if(!($this->alvara)){
            session()->flash('message', 'ALVARÁ DE FUNCIONAMENTO NÃO ENCONTRADO');
            return false;
        }

        return true;

    }

    public function render()
    {
        return view('livewire.alvara-funcionamento.validar');
    }
}
