<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\BaseController as BaseController;
use App\Models\Financeiro;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class FinanceiroController extends BaseController
{
    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Log::info('ENVIOU FINANCEIROS.');

        $retorno = [];
        $erro = [];

        foreach ($request->post()['financeiro'] as $financeiro) {
            try {
                Financeiro::updateOrCreate(
                    [
                        'idfinanceiro' => $financeiro['idfinanceiro'],
                        'empresa' => $financeiro['empresa']
                    ],
                    [
                        'idfinanceiro' => $financeiro['idfinanceiro'],
                        'cnpj_cpf' => $financeiro['cnpj_cpf'],
                        'data' => $financeiro['data'],
                        'vencimento' => $financeiro['vencimento'],
                        'documento' => $financeiro['documento'],
                        'tipotributo' => $financeiro['tipotributo'],
                        'codigotributo' => $financeiro['codigotributo'],
                        'historico' => $financeiro['historico'],
                        'numeroparcela' => $financeiro['numeroparcela'],
                        'descricao' => $financeiro['descricao'],
                        'valor' => $financeiro['valor'],
                        'situacao' => $financeiro['situacao'],
                        'exercicio' => $financeiro['exercicio'],
                        'empresa' => $financeiro['empresa'],
                        'codigobarra' => $financeiro['codigobarra'],
                        'nossonumero' => $financeiro['nossonumero'],
                        'contareceita' => $financeiro['contareceita'],
                        'cb_codigobanco' => $financeiro['cb_codigobanco'],
                        'cb_agencia' => $financeiro['cb_agencia'],
                        'cb_dgagencia' => $financeiro['cb_dgagencia'],
                        'cb_contabancaria' => $financeiro['cb_contabancaria'],
                        'cb_dgcontabancaria' => $financeiro['cb_dgcontabancaria'],
                        'cb_descricaocontabancaria' => $financeiro['cb_descricaocontabancaria'],
                        'valor_pago' => $financeiro['valor_pago'],
                        'juros' => $financeiro['juros'],
                        'multa' => $financeiro['multa'],
                        'desconto' => $financeiro['desconto'],
                        'dtpagamento' => $financeiro['dtpagamento'],
                        'linhadigitavel' => $financeiro['linhadigitavel'] ?? '',
                    ]
                );

                $retorno[] = 'Financeiro atualizado com sucesso (' . $financeiro['empresa'] . ')';

            } catch (\Exception $exception) {
                $erro[$financeiro['idfinanceiro']] = $exception->getMessage();
            }
        }

        return $this->sendResponse($retorno, 'Resposta', $erro);
    }

}
