<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\AlvaraFuncionamento;
use App\Models\Nfse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class AlvaraFuncionamentoController extends BaseController
{
    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Log::info('ENVIOU ALVARÁ.-----------------------------------------------------------');
        Log::info($request);

        $retorno = [];
        $erro = [];

        foreach ($request->post()['alvara'] as $key => $alvara) {
            try {
                AlvaraFuncionamento::updateOrCreate(
                    [
                        'numero' => $alvara['numero']
                    ],
                    [
                        'numero' => $alvara['numero'],
                        'empresa' => $alvara['empresa'],
                        'validacao' => $alvara['validacao'],
                    ]
                );

                $retorno[] = 'Alvará de Funcionamento atualizado com sucesso (' . $alvara['numero'] . ')';

            } catch (\Exception $exception) {
                $erro[$alvara['numero']] = $exception->getMessage();
            }
        }

        return $this->sendResponse($retorno, 'Resposta', $erro);
    }
}
