// JavaScript Document

$(function(){
	try{
		$("#menu_sup, .jquery").show();
		$("#menu_sup").menu();
		$(document).tooltip();
	} catch(err){}
	//Status
	$("#log img").hide();
	$("#log").ajaxStart(function(){
		$('html').css({cursor: 'progress'});
		$(this).children().show();
	});
	$("#log").ajaxStop(function(){
		$('html').css({cursor: 'default'});
		$(this).children().hide();
	});
	//Layout
	$('.button').addClass('ui-widget ui-widget-header ui-corner-all');	
	$('#menuTopo li, #rodape').addClass('ui-corner-all');
	$('.menu_sup, .menu_sup li, #menu_sup').addClass('ui-corner-top');
	$('#menu_sup').removeClass('ui-corner-all');
    $('.conteudo').addClass('ui-corner-bottom');
	
	try{
		var height = $(window).height();
		var top = (height - $('.msg').height()) / 2;
		$('.msg').offset({ top: top });
	} catch(exception){ alert(exception); }
	//Metodos
	$('.msg').click(function(){ $(this).fadeOut('slow'); });
	$('.msg').delay(3000).fadeOut('slow');
	
	//Temas
    try { 
        $('#temasPanel').themeswitcher({
            width:250,
			imgpath: "jquery/images/",
            initialText:'Mudar Tema',
            buttonPreText:"Mudar: "
        });
    } catch(exception){ }
});

/**
 * Metodo de verificação de campos universal, recebe 1 ou N argumentos
 * modelo: onsubmit="return verificarCampos('name do campo'...);"
 */
var VERIFICA = 0;

var verificarCampos = function(){
    //verifica se é um array
    if(arguments.length == 1 && Object.prototype.toString.call(arguments[0]) === "[object Array]"){
        arguments = arguments[0];
    }
    VERIFICA = arguments.length;
    var resposta = true;
    for(var i = 0; i < arguments.length; i++){ 
        var campo = $('#' + arguments[i]);
        if(campo.val() == undefined){//se for radio ou checkbox
            campo = $('input[name=' + arguments[i] + ']:checked');
        }
        if(campo.val() == "" || campo.val() == undefined){
            resposta = false;
            if(campo.val() == undefined){
                campo = $('input[name=' + arguments[i] + ']');
            }
            var message = campo.attr('message') != undefined ? campo.attr('message') : 'Campo obrigat&oacute;rio!';
            printMsg(message, campo);
        } else {
            resposta = validaCampo(campo);
            if(resposta){
                VERIFICA--;
            }
        }
    }
    if(VERIFICA == 0){
        resposta = true;
    } else {
        resposta = false;
    }
    return resposta;
}

function clearMsg(campo){ 
    if(campo.attr('type') == 'radio' || campo.attr('type') == 'checkbox'){
        campo = $('input[name='+campo.attr('name')+']'); 
    }
    if($("div").hasClass('msgGlobal') && VERIFICA <= 1){//nao deve exibir a mensagem
        $(".msgGlobal").html(null);
    } else {
        campo.next().detach('.msgError');
    }
}

function printMsg(msg, campo){
    if($("*").hasClass('msgGlobal')){
        $(".msgGlobal").html(msg);
    } else {
        //Obs. Testar se campo for radio ou checkbox
        if(msg != "" && msg != null){
            campo.next().detach('.msgError');
            campo.after("<span class=\"msgError msgs\"><img class=\"ui-icon ui-icon-triangle-1-w\"/><span class=\"ui-state-highlight\">"+msg+"</span></span>");
        }
    }
    campo.effect('highlight', null, 1000, null);
    //Eventos
    $('.msgs').click(function(){
        $(this).fadeOut('slow');
    });
    $('.msgs').delay(4000).fadeOut('slow');
}

function validaCampo(campo){
    clearMsg(campo);
    var resposta = 0;
    if(campo != "" && campo != null){
        if(campo.attr('min') != undefined && campo.attr('min') != ""){
            resposta += validaTamanhoMin(campo) ? 0 : 1;
        }
        if(campo.attr('max') != undefined && campo.attr('max') != ""){
            resposta += validaTamanhoMax(campo) ? 0 : 1;
        }
        if(campo.attr('compare') != undefined && campo.attr('compare') != ""){
            resposta += comparaCampos(campo) ? 0 : 1;
        }
        if(campo.attr('validate') != undefined && campo.attr('validate') != ""){
            resposta += validate(campo) ? 0 : 1;
        }
    }
    return resposta > 0 ? false : true;
}

function validaTamanhoMax(campo){
    var maximo =  parseInt(campo.attr('max'));
    if(campo.val().length > maximo){ 
        printMsg('Tamanho limite excedido! max. '+maximo, campo); 
        return false;
    }
    return true;
}

function validaTamanhoMin(campo){
    var minimo = parseInt(campo.attr('min'));
    if(campo.val().length < minimo){ 
        printMsg('Tamanho mínimo inv&aacute;lido! min. '+minimo, campo); 
        return false;
    }
    return true;
}

function comparaCampos(campo){
    elementCompare = $('#' + campo.attr('compare'));
    if(elementCompare.val() != campo.val()){ 
        printMsg('Dados incompatíveis!', campo); 
        return false; 
    }
    return true;
}

function validate(campo){
    var metodo = campo.attr('validate'); 
    if(metodo == 'email'){
        return validaEmail(campo);
    } else if(metodo = 'caracteres'){
        return validaCaracteres(campo);
    }
}

function validaEmail(campo){
    exp = /^[\w-]+(\.[\w-]+)*@(([\w-]{2,63}\.)+[A-Za-z]{2,6}|\[\d{1,3}(\.\d{1,3}){3}\])$/;
    if(!exp.test(campo.val())){
        printMsg('E-mail inválido!', campo); 
        return false;
    } else {
        return true;
    }
}

function validaCaracteres(campo) {
    var regex = '[^a-zA-Z0-9]+';
    if(campo.val().match(regex) != "" && campo.val().match(regex) != null) {
        printMsg('Valor de campo inválido! Não utilize acentos ou espaços.', campo);
        return false;
    }
    return true;
}

function obterCamposRequired(idForm){
    var fields = $(idForm+' :input:not(:hidden),'+idForm+' select,'+idForm+' textarea');
    var campos = new Array();
	try{
		for(var i = 0; i < fields.length; i++){
			if($(fields[i]).attr('req') == 'true' 
				|| ($(fields[i]).attr('type') != 'radio' 
					&& $(fields[i]).attr('type') != 'checkbox' 
					&& $(fields[i]).val().length > 0 
					&& ($(fields[i]).attr('req') != undefined && $(fields[i]).attr('req') != 'false')) ){
					
				campos.push(new String(fields[i].id));
			}
		}
	} catch(ex){ }
	return campos;
}

function geraHoraAtual(){
	var data = new Date();
	var hora = data.getHours();
	var minuto = data.getMinutes();
	var segundo = data.getSeconds();
	if(hora < 10){ hora = '0'+hora;}
	if(minuto < 10){ minuto = '0'+minuto;}
	if(segundo < 10){ segundo = '0'+segundo;}
	$('#hora').val(hora+':'+minuto+':'+segundo);
}

/** Sistema ************/

function salvarSistema(){
	var retorno = verificarCampos('nome','versao','descricao');
	var upload = $('#arquivoFile').val();
	var arquivo = $('#arquivo').val();
	if(retorno && (arquivo != "" || upload != "")){
		return true;
	} else {
		if(arquivo == "" && upload == ""){ 
			printMsg('Escolha um Arquivo por Nome ou por Upload!', $('#arquivoFile'));
			printMsg('Escolha um Arquivo por Nome ou por Upload!', $('#arquivo')); 
		}
		return false;
	}
}

/**** Usuário **************/

function buscaUsuarios(){
	var tipo = $("#tipo").val();
	var valor = $("#valor").val();
	if(valor != "" && tipo == ""){
		alert('Selecione ao menos um tipo de busca.');
		return false;	
	} else {		
		return true;
	}
}

function alterarStatusUsuario(){
	var s = $('#statusUsuario').val();
	var status = (s == 'Ativo' ? 'Inativo' : 'Ativo');	
	$('#statusUsuario').val(status);
	$('#dialogConfirm').dialog('open');
}
	
function detalharUsuario(id, status){
	$('#idUsuarioD').val(id);
	$('#idUsuario').val(id);
	$('#statusUsuario').val(status);
	$.ajax({
		url: 'detalheUsuario.php',
		type: 'POST',
		data: { id: id },
		success: function(data){ 
			$('#detalheUsuario').html(data);
			$('#dialogDetalheUser').dialog('open');
		},
		error: function(){ alert('Erro'); }
	});
}

function editarUsuario(id){
	if(id != ""){
		try{
			$.ajax({
				url: 'cadUsuario.php',
				type: 'POST',
				data: { id: id },
				success: function(data){
					$('#edicaoUsuarioAlt').html(data);
					$('#dgUsuario').dialog('open');
				},
				error: function(){ alert('Erro ao exibir o Usuário ( '+id+' )'); }
			});
		} catch(err){ alert(err); }
	}
}

function detalharUsuarioTemp(id){
	try{
		$.ajax({
			url: 'detalheUsuario.php',
			type: 'POST',
			data: { id: id, temp: true },
			success: function(data){
				$('#detalheUsuario').html(data);
				$('#dialogDetalheUser').dialog('open');
			},
			error: function(){ alert('Erro'); }
		});
	} catch(ex){}
}

function enviarEmails(){
	var emails = $("input[name='usuarios[]']:checked");
	if(emails.length > 0){
		params = "";
		$.each(emails, function(key, user){
			if(validaEmail($(user))){
				params += $(user).val()+', ';
			}
		});
		window.location.href = 'email.php?email='+params.substring(0, params.length - 2);
	} else {
		alert('Nenhum E-mail selecionado!');
	}
}

function selecionarTodos(){
	if($('#selectAll:checked').val() == 'true' && $("input[name='usuarios[]']:checked").length == 0){
		$('.users').attr('checked','checked');
	} else {
		$('.users').removeAttr('checked');
	}
}