<?php
$idUsuario = (!empty($_POST['id']) ? $_POST['id'] : NULL);

if(!is_null($idUsuario)){
	include 'beans/GerenciadorUsuario.class.php';
	
	$userMB = new GerenciadorUsuario();
	$usuario = $userMB->detalharUsuario($idUsuario);
	
	echo '<input type="hidden" name="id" value="'.$usuario->getId().'"/>';
	echo '<style> .hidden{ display:none; } </style>';
} else {
	$usuario = new Usuario();
}
?>

<script type="text/javascript" src="/resources/jquery/jquery.maskedinput-1.3.min.js"></script>
<script type="text/javascript">
$(function() {
	$("#cep").mask("99999-999");
	$("#telefone").mask("(99) 9999-9999");
	
	try {
		var cep = "<?=$usuario->getCep()?>"; 
		var cidade = "<?=utf8_encode($usuario->getCidade())?>"; 
		var uf = "<?=$usuario->getUf()?>"; 
		var bairro = "<?=utf8_encode($usuario->getBairro())?>";
		
		$.ajax({
			url: "/cliente/camposCepWS.php", 
			type: 'POST', 
			data: { cep: cep, cidade: cidade, uf: uf, bairro: bairro }, 
			success: function(data){ 
				$('#camposCepWS').html(data); 
			},
			error: function(jqXHR, textStatus, errorThrown){ 
				alert(jqXHR+' ! '+textStatus+' ! '+errorThrown); 
			}
		});
	} catch(exception) {
		alert(exception);
	}

	$("#buscaCep").click(function(){
		var cep = $('#cep').val();
		
		$.ajax({ 
			url : "camposCepWS.php", 
			type : 'POST',
			data : { cep: cep}, 
			success : function(data){ 
				$('#camposCepWS').html(data); 
			} 
		});
	});
});
</script>

<div class="forms">
<table>
  <tr>
    <td>
		<label class="label">*Nome:</label>
		<input type="text" name="nome" id="nome" maxlength="45" size="50" class="ui-widget ui-widget-content ui-corner-all campo" value="<?=utf8_encode($usuario->getNome())?>"/>
	</td>
    <td>
		<span class="hidden">
			<label class="label">*Login:</label>
			<input type="text" name="login" autocomplete="off" id="login" maxlength="15" size="50" class="ui-widget ui-widget-content ui-corner-all campo" onblur="verificaLogin(this);" value="<?=utf8_encode($usuario->getUsuario())?>"/>
        	<span id="verificado" class="mensagemP"></span>
		</span>
   </td>
  </tr>
  <tr>
    <td>
		<span class="hidden">
			<label class="label">*Senha:</label>
			<input type="password" name="senha" id="senha" autocomplete="off" maxlength="15" size="50" class="ui-widget ui-widget-content ui-corner-all campo" value="<?=$usuario->getSenha()?>"/>
		</span>
	</td>
    <td>
		<span class="hidden">
			<label class="label">*Confirme a Senha:</label>
			<input type="password" name="confirma" id="confirma" autocomplete="off" maxlength="15" size="50" compare="senha" class="ui-widget ui-widget-content ui-corner-all campo"/>
		</span>
	</td>
  </tr>
  <tr>
    <td>
		<label class="label">*E-mail:</label>
		<input type="text" name="email" id="email" maxlength="45" size="50" class="ui-widget ui-widget-content ui-corner-all campo" validate="email" value="<?=$usuario->getEmail()?>"/>
        <span id="msgEmail" class="mensagemP"></span>
	</td>
    <td>
		<label class="label">Telefone:</label>
		<input type="text" name="telefone" id="telefone" maxlength="14" size="50" class="ui-widget ui-widget-content ui-corner-all campo" value="<?=$usuario->getTelefone()?>"/></td>
  </tr>
  <tr>
    <td>
		<label class="label">*Tipo de Instituição:</label>
		<select id="tipoInst" name="tipoInst" class="ui-widget ui-widget-content ui-corner-all campoSelect" style="width:330px;">
        	<option selected="selected" value="<?=utf8_encode($usuario->getTipoInst())?>" >
				<?php echo $usuario->getTipoInst() != "" ? utf8_encode($usuario->getTipoInst()) : 'Selecione'; ?>
			</option>
        	<option>Prefeitura</option>
        	<option>C&acirc;mara de Vereadores</option>
        	<option>Funda&ccedil;&atilde;o</option>
        	<option>Autarquia</option>
        	<option>Fundo</option>
        	<option>Instituto de Previd&ecirc;ncia</option>
        	<option>Autarquia Estadual de Autonomia Mista</option>
        	<option>Outros</option>
      </select>
  </td>
    <td>
		<label class="label">*Nome da Instituição:</label>
		<input type="text" name="instituicao" id="instituicao" maxlength="100" size="50" class="ui-widget ui-widget-content ui-corner-all campo" value="<?=utf8_encode($usuario->getInstituicao())?>"/></td>
  </tr>
</table>
<fieldset>
	<legend>Localização:</legend>
	
	<label class="label">*Cep:</label>
 	<input type="text" name="cep" id="cep" maxlength="9" size="46" class="ui-widget ui-widget-content ui-corner-all campo" value="<?=$usuario->getCep(); ?>"/>
 	<button type="button" id="buscaCep" class="button" title="Buscar CEP">
		<span class="ui-icon ui-icon-search" style="float:left;"></span> Buscar CEP
	</button>
  	<div id="camposCepWS">
		<div style="padding:3px;border:1px #333 solid;font-weight:bold;margin:5px 0;">
			<img src="/resources/imagens/loading.gif" align="absmiddle"/> Carregando...
		</div>
	</div>
</fieldset>

<label class="label">*Código de Segurança:</label>
  <?php
	$i = 0; 
	$str = "";
	
	while( $i < 8 ){
		$num = rand(48,122);
		
		if((49<$num && $num<58 )||( 64<$num && $num<91 )||( 97<$num && $num<122 )){
			$str .= chr($num);
			$i++;
		}
	}
?>
  <img src="/cliente/imgSeguranca.php?str=<?=$str?>" height="25" width="90"/>
  <input type="text" name="codSeguranca" id="codSeguranca" autocomplete="off" size="12" maxlength="8" min="8" compare="codSeg" class="ui-widget ui-widget-content ui-corner-all campo"/>
  <span class="textoMini">*Digite o código de segurança ao lado</span> 
</div>

<div class="textoMini" align="right">Campos obrigatórios ( * )</div>
<input type="hidden" value="<?=$str?>" id="codSeg" />
