<?php

/**
 * @author Bruno
 */
class ServiceMessages {

    private static $instance;

    private function __construct() {
    }

    public static function getInstancia() {
        if (!isset(self::$instance)) {
            $c = __CLASS__;
            self::$instance = new $c;
        }
        return self::$instance;
    }

    public function getSession() {
        return $_SESSION;
    }

    public function getObjeto($nome) {
        if (empty($_SESSION)) {
           @session_start();
        }
        $objeto = $_SESSION[$nome];
        return $objeto;
    }

    public function setObjeto($nome, $valor) {
        if (empty($_SESSION)) {
            @session_start();
        }
        $_SESSION[$nome] = $valor;
    }

    public function destroyObjeto($nome) {
        if (empty($_SESSION)) {
            @session_start();
        }
        unset($_SESSION[$nome]);
    }

    public function getMensagem() {
        if (empty($_SESSION)) {
            @session_start();
        }
        if (!isset($_SESSION['mensagem'])) {
            $_SESSION['mensagem'] = "";
        }
		
        $mensagem = $_SESSION['mensagem'];
		
        return $mensagem;
    }

    public function setMensagem($mensagem) {
        if (empty($_SESSION)) {
            @session_start();
        }
		
        $_SESSION['mensagem'] = $mensagem;
    }

    public function destroy() {
        if (empty($_SESSION)) {
            @session_start();
        }
        unset($_SESSION['mensagem']);
    }

    public function limparSessao() {
        if (empty($_SESSION)) {
            @session_start();
        }
        session_destroy();
    }

    /**
     *
     * @param <type> $message
     * @param <type> $nivel 1= Atenção, 2= Informação, 3= Erro
     */
    public function setMessage($message, $nivel) {
        if (empty($_SESSION)) {
            @session_start();
        }
        if (!empty($_SESSION['message']['msg'])) {
            $_SESSION['message']['msg'] .= "<br />" . $message;
            $_SESSION['message']['nivel'] .= "<br />" . $nivel;
        } else {
            $_SESSION['message']['msg'] = $message;
            $_SESSION['message']['nivel'] = $nivel;
        }
    }

    public function printMessage() {
        if (empty($_SESSION)) {
            @session_start();
        }
        if (!empty($_SESSION['message'])) {
            $nivel = $_SESSION['message']['nivel'];
            $classe = "closethick";
            if ($nivel == 1) {
                $nivel = "Atenção";
                $classe = "alert";
            } else if ($nivel == 2) {
                $nivel = "Informação";
                $classe = "info";
            } else if ($nivel == 3) {
                $nivel = "Erro";
            }
            $message = "<div class=\"msg msg$classe ui-corner-all\" id=\"mensagemGlobal\"><span class=\"ui-icon ui-icon-".$classe."\"></span><div>" .utf8_encode($_SESSION['message']['msg']) . "</div></div>";
            print('<script>$("#dgMsgGlobal").dialog("open");</script>'.$message);
            unset($_SESSION['message']);
        }
    }

}

?>