<?php

/**
 * @author Eticons
 * @table(name=tb_cliente)
 */
class Cliente {

    /**     * @id * @column(name=id) */
    private $id;
    /**     * @column(name=nome) */
    private $nome;
    /**     * @column(name=cnpjCpf) */
    private $cnpjCpf;
    /**     * @column(name=tipoInstituicao) */
    private $tipoInstituicao;
    /**     * @column(name=liberado) */
    private $liberado;
    /**     * @column(name=status) */
    private $status;
    /**     * @column(name=cnpjCpfValidado) */
    private $cnpjCpfValidado;
    /**     * @column(name=dataBloqueio) */
    private $dataBloqueio;
    /**     * @column(name=razao) */
    private $razao;
    /**     * @column(name=nomeFantasia) */
    private $nomeFantasia;
    
    /**     * @transient */
    private $movimento;
    /**     * @transient */
    private $dataAtualizacao;

    public function getId() {
        return $this->id;
    }

    public function setId($id) {
        $this->id = $id;
    }

    public function getNome() {
        return $this->nome;
    }

    public function setNome($nome) {
        $this->nome = $nome;
    }

    public function getCnpjCpf() {
        return $this->cnpjCpf;
    }

    public function setCnpjCpf($cnpjCpf) {
        $this->cnpjCpf = $cnpjCpf;
    }

    public function getTipoInstituicao() {
        return $this->tipoInstituicao;
    }

    public function setTipoInstituicao($tipoInstituicao) {
        $this->tipoInstituicao = $tipoInstituicao;
    }

    public function getLiberado() {
        return $this->liberado;
    }

    public function setLiberado($liberado) {
        $this->liberado = $liberado;
    }

    public function getStatus() {
        return $this->status;
    }

    public function setStatus($status) {
        $this->status = $status;
    }

    public function getCnpjCpfValidado() {
        return $this->cnpjCpfValidado;
    }

    public function setCnpjCpfValidado($cnpjCpfValidado) {
        $this->cnpjCpfValidado = $cnpjCpfValidado;
    }

    public function getDataBloqueio() {
        return $this->dataBloqueio;
    }

    public function setDataBloqueio($dataBloqueio) {
        $this->dataBloqueio = $dataBloqueio;
    }

    public function getRazao() {
        return $this->razao;
    }

    public function setRazao($razao) {
        $this->razao = $razao;
    }

    public function getNomeFantasia() {
        return $this->nomeFantasia;
    }

    public function setNomeFantasia($nomeFantasia) {
        $this->nomeFantasia = $nomeFantasia;
    }

    public function getMovimento() {
        return $this->movimento;
    }

    public function setMovimento($movimento) {
        $this->movimento = $movimento;
    }

    public function getDataAtualizacao() {
        return $this->dataAtualizacao;
    }

    public function setDataAtualizacao($dataAtualizacao) {
        $this->dataAtualizacao = $dataAtualizacao;
    }

    public function toArray() {
        return array("id" => $this->id,
            "nome" => utf8_encode($this->nome),
            "cnpjCpf" => $this->cnpjCpf,
            "tipoInstituicao" => utf8_encode($this->tipoInstituicao),
            "liberado" => $this->liberado,
            "status" => $this->status,
            "cnpjCpfValidado" => $this->cnpjCpfValidado,
            "dataBloqueio" => $this->dataBloqueio,
            "razao" => utf8_encode($this->razao),
            "nomeFantasia" => utf8_encode($this->nomeFantasia)
        );
    }

    public function toArquivo() {
        return array("id" => $this->id,
            "nome" => utf8_encode($this->nome),
            "cnpjCpf" => $this->cnpjCpf,
            "tipoInstituicao" => utf8_encode($this->tipoInstituicao),
            "liberado" => $this->liberado,
            "status" => $this->status,
            "cnpjCpfValidado" => $this->cnpjCpfValidado,
            "dataBloqueio" => $this->dataBloqueio,
            "razao" => utf8_encode($this->razao),
            "nomeFantasia" => utf8_encode($this->nomeFantasia),
            "movimento" => utf8_encode($this->movimento),
            "dataAtualizacao" => $this->dataAtualizacao
        );
    }

}

?>



