<?php

require_once 'Conexao.class.php';

/**
 * Description of DAOSistemas
 *
 * @author Bruno
 */
class DAOSistemas {

    private $conexao = null;

    function __construct() {
        $this->conexao = new Conexao();
    }

    public function getSistemas() {
        try {
            $con = $this->conexao->getConexao();
            $stmt = $con->query("SELECT *, DATE_FORMAT(data, '%d/%m/%Y - %T') AS data FROM tb_sistema WHERE arquivo != ''");
            $this->conexao->desconectar();
            $i = 0;
            if ($stmt) {
                while ($row = $stmt->fetchObject(get_class(new Sistema()))) {
                    $lista[$i] = $row;
                    $i++;
                }
                return $lista;
            } else {
                return null;
            }
        } catch (PDOException $ex) {
            die($ex->getMessage());
        }
    }

    public function getSistema($query) {
        try {
            $con = $this->conexao->getConexao();
            $stmt = $con->query($query);
            $this->conexao->desconectar();
            if ($stmt) {
                $sistema = $stmt->fetchObject(get_class(new Sistema()));
                return $sistema;
            } else {
                return new Sistema();
            }
        } catch (PDOException $ex) {
            die($ex->getMessage());
        }
    }

}

?>
