<?php

require_once 'Conexao.class.php';

/**
 * Description of DAONoticia
 *
 * @author Eticons
 */
class DAONoticia {

    private $conexao = null;

    function __construct() {
        $this->conexao = new Conexao();
    }

    public function buscaNoticias($query) {
        try {
            $con = $this->conexao->getConexao();
            $stmt = $con->query($query);
            $this->conexao->desconectar();
            $i = 0;
            $lista = array();
            if ($stmt) {
                while ($row = $stmt->fetchObject(get_class(new Noticia()))) {
                    $lista[$i] = $row;
                    $i++;
                }
                return $lista;
            } else {
                return array();
            }
        } catch (PDOException $ex) {
            die($ex->getMessage());
        }
    }

    public function getNoticias() {
        try {
            $con = $this->conexao->getConexao();
            $stmt = $con->query("SELECT *, DATE_FORMAT(n.dataNoticia, '%d/%m/%Y %Hh%im') AS dataNoticia FROM tb_noticia n ORDER BY n.dataNoticia DESC LIMIT 0,4");
            $this->conexao->desconectar();
            $i = 0;
            $lista = array();
            if ($stmt) {
                while ($row = $stmt->fetchObject(get_class(new Noticia()))) {
                    $lista[$i] = $row;
                    $i++;
                }
                return $lista;
            } else {
                return array();
            }
        } catch (PDOException $ex) {
            die($ex->getMessage());
        }
    }

}

?>
