<?php

require_once 'Conexao.class.php';

/**
 * Description of DAOHelpDesk
 *
 * @author Eticons
 */
class DAOHelpDesk {

    private $conexao = null;

    function __construct() {
        $this->conexao = new Conexao();
    }

    public function buscaChamados($query) {
        try {
            $con = $this->conexao->getConexao();
            $stmt = $con->query($query);
            $this->conexao->desconectar();
            $i = 0;
            $lista = array();
            if ($stmt) {
                while ($row = $stmt->fetchObject(get_class(new Chamados()))) {
                    $lista[$i] = $row;
                    $i++;
                }
                return $lista;
            } else {
                return array();
            }
        } catch (PDOException $ex) {
            die($ex->getMessage());
        }
    }

    public function buscaMensagens($query) {
        try {
            $con = $this->conexao->getConexao();
            $stmt = $con->query($query);
            $this->conexao->desconectar();
            $i = 0;
            $lista = array();
            if ($stmt) {
                while ($row = $stmt->fetchObject(get_class(new Mensagem()))) {
                    $lista[$i] = $row;
                    $i++;
                }
                return $lista;
            } else {
                return array();
            }
        } catch (PDOException $ex) {
            die($ex->getMessage());
        }
    }

}

?>
