<?php

require_once 'Conexao.class.php';

/**
 * Description of DAOCliente
 *
 * @author Bruno
 */
class DAOCliente {

    private $conexao = null;

    function __construct() {
        $this->conexao = new Conexao();
    }

    public function logar($login, $senha) {
        try {
            $con = $this->conexao->getConexao();
            $stmt = $con->query("SELECT * FROM tb_usuariorestrito WHERE usuario='$login' AND senha='$senha' AND statusUsuario='Ativo' AND liberado = 'S'");
            $this->conexao->desconectar();
            if (!$result = $stmt->fetchObject(get_class(new UsuarioRestrito()))) {
                return null;
            } else {
                return $result;
            }
        } catch (PDOException $ex) {
            die($ex->getMessage());
        }
    }

    public function verificaLogin($login) {
        try {
            $con = $this->conexao->getConexao();
            $stmt = $con->query("SELECT COUNT(*) AS cont FROM tb_usuariorestrito WHERE usuario='$login'");
            $this->conexao->desconectar();
            $login = "";
            if ($stmt) {
                $login = $stmt->fetch();
                return $login['cont'];
            } else {
                return "";
            }
        } catch (PDOException $ex) {
            die($ex->getMessage());
        }
    }

    public function buscarUsuarios($query) {
        try {
            $con = $this->conexao->getConexao();
            $stmt = $con->query($query);
            $this->conexao->desconectar();
            $i = 0;
            $lista = array();
            if ($stmt) {
                while ($row = $stmt->fetchObject(get_class(new UsuarioRestrito()))) {
                    $lista[$i] = $row;
                    $i++;
                }
                return $lista;
            } else {
                return array();
            }
        } catch (PDOException $ex) {
            die($ex->getMessage());
        }
    }

    public function buscarClientes($query) {
        try {
            $con = $this->conexao->getConexao();
            $stmt = $con->query($query);
            $this->conexao->desconectar();
            $i = 0;
            $lista = array();
            if ($stmt) {
                while ($row = $stmt->fetchObject(get_class(new Cliente()))) {
                    $lista[$i] = $row;
                    $i++;
                }
                return $lista;
            } else {
                return array();
            }
        } catch (PDOException $ex) {
            die($ex->getMessage());
        }
    }

    public function buscarClientesSistemas($query) {
        try {
            $con = $this->conexao->getConexao();
            $stmt = $con->query($query);
            $this->conexao->desconectar();
            $i = 0;
            $lista = array();
            if ($stmt->rowCount() > 0) {
                while ($row = $stmt->fetchObject(get_class(new ClienteSistema()))) {
                    $lista[$i] = $row;
                    $i++;
                }
                return $lista;
            } else {
                return $lista;
            }
        } catch (PDOException $ex) {
            die($ex->getMessage());
        }
    }

    public function verificaCliente($cnpjCpf) {
        try {
            $con = $this->conexao->getConexao();
            $stmt = $con->query("SELECT * FROM tb_cliente WHERE cnpjCpf='$cnpjCpf'");
            $this->conexao->desconectar();
            $i = 0;
            if ($stmt->rowCount() > 0) {
                while ($row = $stmt->fetchObject(get_class(new Cliente()))) {
                    $lista[$i] = $row;
                    $i++;
                }
                return $lista[0];
            } else {
                return NULL;
            }
        } catch (PDOException $ex) {
            die($ex->getMessage());
        }
    }

    public function verificaClienteSistema($clienteSistema) {
        try {
            $con = $this->conexao->getConexao();
            $stmt = $con->query("SELECT COUNT(*) AS cont FROM tb_cliente_sistema WHERE id_cliente=" . $clienteSistema->getId_cliente() . " AND id_sistema=" . $clienteSistema->getId_sistema());
            $this->conexao->desconectar();
            $login = "";
            if ($stmt) {
                $login = $stmt->fetch();
                return $login['cont'];
            } else {
                return "";
            }
        } catch (PDOException $ex) {
            die($ex->getMessage());
        }
    }

    public function getInformacoesInicio($responsavel) {
        try {
            $query = "SELECT COUNT(*) AS solicitantes,(SELECT COUNT(*) FROM tb_chamados WHERE statusChamado = 1) AS novosChamados,
                (SELECT COUNT(*) FROM tb_chamados WHERE responsavel = $responsavel) AS meusChamados FROM tb_usuariorestrito WHERE liberado = 'N'";
            $con = $this->conexao->getConexao();
            $stmt = $con->query($query);
            $this->conexao->desconectar();
            return $stmt->fetchAll();
        } catch (PDOException $ex) {
            die($ex->getMessage());
        }
    }

}

?>
