<?php

include 'daos/DAOSugestoes.class.php';

/**
 * Description of ControladorSugestoes
 *
 * @author Eticons
 */
class ControladorSugestoes {

    private $dao;

    function __construct() {
        $this->dao = new DAOSugestoes();
    }

    public function getSugestoes() {
        $query = "SELECT s.*, DATE_FORMAT(s.dataEnvio, '%d/%m/%Y, %H:%i:%s') AS dataEnvio, u.nome as usuario
                  FROM tb_sugestoes s INNER JOIN tb_usuario u ON u.id = s.usuario WHERE s.situacao = 0 ORDER BY s.dataEnvio DESC";
        return $this->dao->buscarSugestoes($query);
    }

    public function buscarSugestoes($texto, $data, $situacao) {
        if ($situacao == "") { $situacao = 0;}
        $query = "SELECT s.*, DATE_FORMAT(s.dataEnvio, '%d/%m/%Y, %H:%i:%s') AS dataEnvio, u.nome as usuario 
                  FROM tb_sugestoes s INNER JOIN tb_usuario u ON u.id = s.usuario WHERE s.situacao = $situacao ";
         
        if ($texto != "") {
            $query .= " AND s.texto LIKE '%$texto%' ";
        }
        if ($data != "") {
            $query .= " AND CAST(s.dataEnvio AS DATE) = '$data' ";
        }
        $query .= " ORDER BY s.dataEnvio DESC";
        return $this->dao->buscarSugestoes($query);
    }

}

?>
