<?php

require 'daos/DAOSistemas.class.php';

/**
 * Description of ControladorSistemas
 *
 * @author Eticons
 */
class ControladorSistemas {

    private $dao;

    function __construct() {
        $this->dao = new DAOSistemas();
    }

    public function getSistemas() {
        return $this->dao->getSistemas();
    }

    public function getSistemaPorId($id) {
        $query = "SELECT s.id,s.nome,s.descricao,s.arquivo,DATE_FORMAT(s.data, '%d/%m/%Y - %T') AS data,s.instalacao,s.versao,s.imagem,s.texto,c.comentario
				  FROM tb_sistema s LEFT JOIN tb_comentarios c ON c.idSistema = s.id AND s.versao = c.versao WHERE s.id = $id GROUP BY s.id";
        return $this->dao->getSistema($query);
    }

}

?>
