<?php

include 'daos/DAORegistros.class.php';

/**
 * Description of ControladorRegistros
 *
 * @author Eticons
 */
class ControladorRegistros {

    private $dao;

    function __construct() {
        $this->dao = new DAORegistros();
    }

    public function buscarRegistros($valor, $movimento, $dataAcesso, $todos) {
        $query = "";
        if ($todos == "todos") {
            $query = "SELECT r.id,u.nome AS nomeUsuario,r.movimento,DATE_FORMAT(r.dataAcesso, '%d/%m/%Y, %H:%i:%s') AS dataAcesso,
                      c.nome AS nomeCliente,r.detalhes,r.obs,s.nome AS nomeSistema FROM tb_registroacessos r
                      INNER JOIN tb_cliente c ON c.id=r.idCliente LEFT JOIN tb_sistema s ON s.id=r.sistema
                      INNER JOIN tb_usuariorestrito u ON u.id=r.idUsuarioRestrito ORDER BY r.dataAcesso DESC";
        } else {
            $query = "SELECT r.id,u.nome AS nomeUsuario,r.movimento,DATE_FORMAT(r.dataAcesso, '%d/%m/%Y, %H:%i:%s') AS dataAcesso,
                      c.nome AS nomeCliente,r.detalhes,r.obs,s.nome AS nomeSistema FROM tb_registroacessos r
                      INNER JOIN tb_cliente c ON c.id=r.idCliente LEFT JOIN tb_sistema s ON s.id=r.sistema
                      INNER JOIN tb_usuariorestrito u ON u.id=r.idUsuarioRestrito WHERE r.movimento IS NOT NULL ";
            if ($valor != "") {
                $query .= " AND u.nome LIKE '%$valor%' OR c.nome LIKE '%$valor%' OR r.obs LIKE '%$valor%' OR s.nome LIKE '%$valor%' ";
            }
            if ($movimento != "") {
                $query .= " AND r.movimento = '$movimento' ";
            }
            if ($dataAcesso != "") {
                $query .= " AND CAST(r.dataAcesso AS DATE) = '$dataAcesso' ";
            }
            $query .= " ORDER BY r.dataAcesso DESC";
        }
        return $this->dao->buscarRegistros($query);
    }

    public function getRegistro($id) {
        $query = "SELECT r.id,u.nome AS nomeUsuario,r.movimento,DATE_FORMAT(r.dataAcesso, '%d/%m/%Y, %H:%i:%s') AS dataAcesso,
                  c.nome AS nomeCliente,r.detalhes,r.obs,s.nome AS nomeSistema FROM tb_registroacessos r
                  INNER JOIN tb_cliente c ON c.id=r.idCliente LEFT JOIN tb_sistema s ON s.id=r.sistema
                  INNER JOIN tb_usuariorestrito u ON u.id=r.idUsuarioRestrito WHERE r.id = $id";
        $registro = $this->dao->buscarRegistros($query);
        return $registro[0];
    }

}

?>
