<?php

require 'daos/DAOHelpDesk.class.php';

/**
 * Description of ControladorHelpDesk
 *
 * @author Eticons
 */
class ControladorHelpDesk {

    private $dao;

    function __construct() {
        $this->dao = new DAOHelpDesk();
    }

    public function buscaChamados($valor, $sistema, $data, $status, $todos) {
        $query = "SELECT c.codigo,cl.nome AS cliente,u.nome AS usuario,c.responsavel,c.assunto,DATE_FORMAT(c.dataEnvio, '%d/%m/%Y %H:%i:%s') AS dataEnvio,s.nome AS sistema,c.statusChamado
                  FROM tb_chamados c INNER JOIN tb_cliente cl ON cl.id = c.cliente INNER JOIN tb_usuario u ON u.id = c.usuario
                  INNER JOIN tb_sistema s ON s.id = c.sistema WHERE 1 = 1 ";
        if ($todos == "todos") {
            $query .= "";
        } else {
            if ($valor != "") {
                $query .= " AND (c.assunto LIKE '%$valor%' OR cl.nome LIKE '%$valor%' OR u.nome LIKE '%$valor%') ";
            }
            if ($sistema != "") {
                $query .= " AND c.sistema = $sistema ";
            }
            if ($status != "") {
                $query .= " AND c.statusChamado = $status ";
            }
            if ($data != "") {
                $query .= " AND CAST(c.dataEnvio AS DATE) = '$data' ";
            }
        }
        $query .= " ORDER BY c.dataEnvio DESC";
        return $this->dao->buscaChamados($query);
    }

    public function getChamados($codigo) {
        $query = "SELECT c.codigo,cl.nome AS cliente,u.nome AS usuario,ur.nome AS responsavel,c.assunto,DATE_FORMAT(c.dataEnvio, '%d/%m/%Y %H:%i:%s') AS dataEnvio,s.nome AS sistema,c.statusChamado
                  FROM tb_chamados c INNER JOIN tb_cliente cl ON cl.id = c.cliente INNER JOIN tb_usuario u ON u.id = c.usuario
                  INNER JOIN tb_sistema s ON s.id = c.sistema LEFT JOIN tb_usuariorestrito ur ON ur.id = c.responsavel WHERE codigo = $codigo ";
        return $this->dao->buscaChamados($query);
    }

    public function getMensagens($codigo) {
        $query = "SELECT *,DATE_FORMAT(dataResposta, '%d/%m/%Y %H:%i:%s') AS dataResposta FROM tb_mensagem WHERE chamado = $codigo";
        return $this->dao->buscaMensagens($query);
    }

    public function meusChamados($responsavel, $assunto, $status, $data, $todos) {
        $query = "SELECT c.codigo,cl.nome AS cliente,u.nome AS usuario,ur.nome AS responsavel,c.assunto,DATE_FORMAT(c.dataEnvio, '%d/%m/%Y %H:%i:%s') AS dataEnvio,s.nome AS sistema,c.statusChamado
                  FROM tb_chamados c INNER JOIN tb_cliente cl ON cl.id = c.cliente INNER JOIN tb_usuario u ON u.id = c.usuario
                  INNER JOIN tb_sistema s ON s.id = c.sistema LEFT JOIN tb_usuariorestrito ur ON ur.id = c.responsavel WHERE c.responsavel = $responsavel ";
        if ($todos == "todos") {
            $query .= " ORDER BY c.dataEnvio DESC";
        } else {
            if ($assunto != "") {
                $query .= " AND c.assunto LIKE '%$sistema%' ";
            }
            if ($data != "") {
                $query .= " AND CAST(c.dataEnvio AS DATE) = '$data' ";
            }
            if ($status != "") {
                $query .= " AND c.statusChamado = $status ";
            }
            $query .= " ORDER BY c.dataEnvio DESC";
        }
        return $this->dao->buscaChamados($query);
    }

    public function buscaChamadosUsuario($usuario, $assunto, $status, $data, $todos) {
        $query = "SELECT c.codigo,cl.nome AS cliente,u.nome AS usuario,ur.nome AS responsavel,c.assunto,DATE_FORMAT(c.dataEnvio, '%d/%m/%Y %H:%i:%s') AS dataEnvio,s.nome AS sistema,c.statusChamado
                  FROM tb_chamados c INNER JOIN tb_cliente cl ON cl.id = c.cliente INNER JOIN tb_usuario u ON u.id = c.usuario
                  INNER JOIN tb_sistema s ON s.id = c.sistema LEFT JOIN tb_usuariorestrito ur ON ur.id = c.responsavel WHERE c.usuario = $usuario ";
        if ($todos == "todos") {
            $query .= "";
        } else {
            if ($assunto != "") {
                $query .= " AND c.assunto LIKE '%$sistema%' ";
            }
            if ($data != "") {
                $query .= " AND CAST(c.dataEnvio AS DATE) = '$data' ";
            }
            if ($status != "") {
                $query .= " AND c.statusChamado = $status ";
            }
            $query .= " ORDER BY c.dataEnvio DESC";
        }
        return $this->dao->buscaChamados($query);
    }

}

?>
