<?php

include 'daos/DAOCliente.class.php';

/**
 * Description of ControladorClientes
 *
 * @author Eticons
 */
class ControladorClientes {

    private $dao;

    function __construct() {
        $this->dao = new DAOCliente();
    }

    public function logarRestrito($login, $senha) {
        if ($login != "" && $senha != "") {
            return $this->dao->logar($login, $senha);
        } else {
            return null;
        }
    }

    public function verificaLoginRestrito($login) {
        return $this->dao->verificaLogin($login);
    }

    public function buscarUsuariosRestritos($nome, $status, $liberado, $todos) {
        if ($todos == "todos") {
            $query = "SELECT * FROM tb_usuariorestrito";
        } else {
            $query = "SELECT * FROM tb_usuariorestrito WHERE 1=1 ";
            if ($nome != "") {
                $query .= " AND nome LIKE '%$nome%' ";
            }
            if ($status != "") {
                $query .= " AND statusUsuario = '$status' ";
            }
            if ($liberado != "") {
                $query .= " AND liberado = '$liberado' ";
            }
        }
        $query .= " ORDER BY nome";
        return $this->dao->buscarUsuarios($query);
    }

    public function buscarClientes($valor, $instituicao, $liberado, $status, $todos) {
        if ($todos == "todos") {
            $query = "SELECT * FROM tb_cliente ORDER BY nome";
        } else {
            $query = "SELECT * FROM tb_cliente WHERE 1=1 ";
            if ($valor != "") {
                $query .= " AND (nome LIKE '%" . $valor . "%' OR razao LIKE '%" . $valor . "%' OR nomeFantasia LIKE '%" . $valor . "%' OR cnpjCpf LIKE '%" . $valor . "%') ";
            }
            if ($instituicao != "") {
                $query .= " AND tipoInstituicao = '$instituicao' ";
            }
            if ($liberado != "") {
                $query .= " AND liberado = '$liberado' ";
            }
            if ($status != "") {
                $query .= " AND LOWER(status) = LOWER('$status')";
            }
            $query .= " ORDER BY nome";
        }
        return $this->dao->buscarClientes($query);
    }
	
	public function buscarClientesPorSistema($sistema, $cnpj) {
		$query = "SELECT c.nome, c.cnpjCpf, cs.liberado, cs.dataBloqueio FROM tb_cliente c LEFT JOIN tb_cliente_sistema cs ON c.id = cs.id_cliente
				  WHERE LOWER(c.status) = 'ativo' and cs.id_sistema = $sistema AND c.cnpjCpf LIKE '$cnpj' ORDER BY nome";
		return $this->dao->buscarClientes($query);
	}

    public function getClientesParaArquivo() {
        $select = "SELECT c.id, c.nome, c.cnpjCpf, c.tipoInstituicao, c.liberado, c.status, c.cnpjCpfValidado, c.dataBloqueio, c.razao, c.nomeFantasia,
            (SELECT movimento FROM tb_registroacessos WHERE idCliente = c.id ORDER BY dataAcesso DESC LIMIT 1) AS movimento,
            (SELECT DATE_FORMAT(dataAcesso, '%d/%m/%Y %H:%i:%s') FROM tb_registroacessos WHERE idCliente = c.id ORDER BY dataAcesso DESC LIMIT 1) AS dataAtualizacao
            FROM tb_cliente c ORDER BY c.nome";
        return $this->dao->buscarClientes($select);
    }

    public function getClienteSistemas($idCliente) {
        $query = "SELECT cs.id_cliente, cs.id_sistema, DATE_FORMAT(cs.data_implantacao, '%d/%m/%Y') AS data_implantacao, cs.responsavel,
                  cs.contador, cs.liberado, cs.dataBloqueio, c.nome AS nomeCliente, s.nome AS nomeSistema
                  FROM tb_cliente_sistema cs RIGHT JOIN tb_cliente c ON c.id = cs.id_cliente
                  INNER JOIN tb_sistema s ON s.id = cs.id_sistema WHERE cs.id_cliente = $idCliente";

        return $this->dao->buscarClientesSistemas($query);
    }

    public function verificaCliente($cnpjCpf) {
        return $this->dao->verificaCliente($cnpjCpf);
    }

    public function verificaClienteSistema($clienteSistema) {
        return $this->dao->verificaClienteSistema($clienteSistema);
    }

    public function bloqueiaTodosClientes($sistemas) {
        $dataBloqueio = $this->getDataBloqueio();
        if (array_search('100', $sistemas) > -1) {//todos
            $this->dao->executaQuery("UPDATE tb_cliente SET liberado = 'N', dataBloqueio = '$dataBloqueio' WHERE LCASE(status)='ativo'");
            $this->dao->executaQuery("UPDATE tb_cliente_sistema SET liberado = 'N', dataBloqueio = '$dataBloqueio' WHERE id_cliente IN(SELECT id FROM tb_cliente WHERE LCASE(status)='ativo')");
        } else {
            $in = implode(",", $sistemas);
            $this->dao->executaQuery("UPDATE tb_cliente_sistema SET liberado = 'N', dataBloqueio = '$dataBloqueio' WHERE id_sistema IN($in)");
            $this->dao->executaQuery("UPDATE tb_cliente SET liberado = 'N', dataBloqueio = '$dataBloqueio' WHERE id
                                      IN(SELECT DISTINCT cs.id_cliente FROM tb_cliente_sistema cs WHERE
                                      (SELECT COUNT(liberado) FROM tb_cliente_sistema WHERE id_cliente = cs.id_cliente GROUP BY id_cliente) =
                                      (SELECT COUNT(liberado) FROM tb_cliente_sistema WHERE id_cliente = cs.id_cliente AND liberado = 'N' GROUP BY id_cliente)) AND LCASE(status)='ativo'");
        }
    }

    public function liberaTodosClientes($sistemas) {
        $dataBloqueio = date('mY');
        if (array_search('100', $sistemas) > -1) {//todos
            $this->dao->executaQuery("UPDATE tb_cliente SET liberado = 'S', dataBloqueio = '$dataBloqueio' WHERE LCASE(status)='ativo'");
            $this->dao->executaQuery("UPDATE tb_cliente_sistema SET liberado = 'S', dataBloqueio = '$dataBloqueio' WHERE id_cliente IN(SELECT id FROM tb_cliente WHERE LCASE(status)='ativo')");
        } else {
            $in = implode(",", $sistemas);
            $this->dao->executaQuery("UPDATE tb_cliente SET liberado = 'S', dataBloqueio = '$dataBloqueio' WHERE id IN(SELECT id_cliente FROM tb_cliente_sistema WHERE id_sistema IN($in))");
            $this->dao->executaQuery("UPDATE tb_cliente_sistema SET liberado = 'S', dataBloqueio = '$dataBloqueio' WHERE id_sistema IN($in)");
        }
    }

    public function atualizaTodosClientes($clientes) {
        $dataAtual = date('mY');
        $liberaClientes = "UPDATE tb_cliente SET liberado='S', dataBloqueio='$dataAtual' WHERE LCASE(status)='ativo'";
        $this->dao->executaQuery($liberaClientes);
        $liberaClienteSistemas = "UPDATE tb_cliente_sistema SET liberado='S', dataBloqueio='$dataAtual' WHERE id_cliente IN(SELECT id FROM tb_cliente WHERE LCASE(status)='ativo')";
        $this->dao->executaQuery($liberaClienteSistemas);

        $dataBloqueio = $this->getDataBloqueio();
        $bloqueiaClientes = "UPDATE tb_cliente SET liberado = 'N', dataBloqueio = '$dataBloqueio' WHERE cnpjCpf IN($clientes)";
        $this->dao->executaQuery($bloqueiaClientes);
        $bloqueiaClienteSistemas = "UPDATE tb_cliente_sistema SET liberado = 'N', dataBloqueio = '$dataBloqueio' WHERE id_cliente IN(SELECT id FROM tb_cliente WHERE cnpjCpf IN($clientes))";
        $this->dao->executaQuery($bloqueiaClienteSistemas);
    }

    private function getDataBloqueio() {
        $mes = (date('m') - 1);
        $ano = date('Y');
        if ($mes < 01) {
            $mes = '12';
            $ano--;
        }
        if ($mes < 10) {
            $mes = '0' . $mes;
        }
        return $mes . $ano;
    }

    public function getInformacoesInicio($responsavel) {
        return $this->dao->getInformacoesInicio($responsavel);
    }

}

?>
