<?php

require 'controlador/ControladorUsuario.class.php';
require 'controlador/ControladorSistemas.class.php';
require 'controlador/ControladorGenerico.class.php';
require 'controlador/ControladorNoticia.class.php';
require 'controlador/ControladorSugestoes.class.php';
require 'controlador/ControladorClientes.class.php';
require 'controlador/ControladorRegistros.class.php';
require 'controlador/ControladorHelpDesk.class.php';
require 'controlador/ControladorInteressados.class.php';

/**
 * Description of Fachada
 *
 * @author Eticons
 */
class Fachada {

    private $contUsuario;
    private $contSistemas;
    private $contGenerico;
    private $contNoticia;
    private $contSugestoes;
    private $contClientes;
    private $contRegistros;
    private $contHelpDesk;
    private $contInteressados;

    function __construct() {
        $this->contUsuario = new ControladorUsuario();
        $this->contSistemas = new ControladorSistemas();
        $this->contGenerico = new ControladorGenerico();
        $this->contNoticia = new ControladorNoticia();
        $this->contSugestoes = new ControladorSugestoes();
        $this->contClientes = new ControladorClientes();
        $this->contRegistros = new ControladorRegistros();
        $this->contHelpDesk = new ControladorHelpDesk();
        $this->contInteressados = new ControladorInteressados();
    }

    /**
     * ***** Genricos *********************************************************
     * * */
    public function salvar($object) {
        return $this->contGenerico->salvar($object);
    }

    public function alterar($object) {
        return $this->contGenerico->alterar($object);
    }

    public function deletar($object) {
        return $this->contGenerico->deletar($object);
    }

    public function find($entityClass, $primaryKey) {
        return $this->contGenerico->find($entityClass, $primaryKey);
    }

    public function buscaGenerica($tipo, $valor, $objeto) {
        return $this->contGenerico->buscaGenerica($tipo, $valor, $objeto);
    }

    /**
     * ***** Usurio ***********************************************************
     * * */
    public function logar($login, $senha) {
        return $this->contUsuario->logar($login, $senha);
    }

    public function verificaLogin($login) {
        return $this->contUsuario->verificaLogin($login);
    }

    public function verificaUsuario($login, $email) {
        return $this->contUsuario->verificaUsuario($login, $email);
    }

    public function buscarUsuarios($tipo, $valor, $situacao, $todos) {
        return $this->contUsuario->buscarUsuarios($tipo, $valor, $situacao, $todos);
    }

    public function getInformacoes() {
        return $this->contUsuario->getInformacoes();
    }
	
	public function obterUsuarioId($id){
		return $this->contUsuario->obterUsuarioId($id);
	}

    /**
     * ***** Sistemas **********************************************************
     * * */
    public function getSistemas() {
        return $this->contSistemas->getSistemas();
    }

    public function getSistemaPorId($id) {
        return $this->contSistemas->getSistemaPorId($id);
    }

    /**
     * ***** Noticias **********************************************************
     * * */
    public function buscaNoticias($valor, $data) {
        return $this->contNoticia->buscaNoticias($valor, $data);
    }

    public function getNoticias() {
        return $this->contNoticia->getNoticias();
    }

    /**
     * ***** Sugestes *********************************************************
     * * */
    public function getSugestoes() {
        return $this->contSugestoes->getSugestoes();
    }

    public function buscarSugestoes($texto, $data, $situacao) {
        return $this->contSugestoes->buscarSugestoes($texto, $data, $situacao);
    }

    /**
     * ***** Usurio Restrito **************************************************
     * * */
    public function logarRestrito($login, $senha) {
        return $this->contClientes->logarRestrito($login, $senha);
    }

    public function verificaLoginRestrito($login) {
        return $this->contClientes->verificaLoginRestrito($login);
    }

    public function buscarUsuariosRestritos($nome, $status, $liberado, $todos) {
        return $this->contClientes->buscarUsuariosRestritos($nome, $status, $liberado, $todos);
    }

    /**
     * ***** Cliente ***********************************************************
     * * */
    public function buscarClientes($valor, $instituicao, $liberado, $status, $todos) {
        return $this->contClientes->buscarClientes($valor, $instituicao, $liberado, $status, $todos);
    }
	
	public function buscarClientesPorSistema($sistema, $cnpj) {
		return $this->contClientes->buscarClientesPorSistema($sistema, $cnpj);
	}

    public function getClienteSistemas($idCliente) {
        return $this->contClientes->getClienteSistemas($idCliente);
    }

    public function verificaCliente($cnpjCpf) {
        return $this->contClientes->verificaCliente($cnpjCpf);
    }

    public function verificaClienteSistema($clienteSistema) {
        return $this->contClientes->verificaClienteSistema($clienteSistema);
    }

    public function atualizaTodosClientes($clientes) {
        return $this->contClientes->atualizaTodosClientes($clientes);
    }

    public function bloqueiaTodosClientes($sistemas) {
        $this->contClientes->bloqueiaTodosClientes($sistemas);
    }

    public function liberaTodosClientes($sistemas) {
        $this->contClientes->liberaTodosClientes($sistemas);
    }

    public function getInformacoesInicio($responsavel) {
        return $this->contClientes->getInformacoesInicio($responsavel);
    }

    public function getClientesParaArquivo() {
        return $this->contClientes->getClientesParaArquivo();
    }

    /**
     * ***** Registros *********************************************************
     * * */
    public function buscarRegistros($valor, $movimento, $dataAcesso, $todos) {
        return $this->contRegistros->buscarRegistros($valor, $movimento, $dataAcesso, $todos);
    }

    public function getRegistro($id) {
        return $this->contRegistros->getRegistro($id);
    }

    /**
     * ***** Hel-Desk **********************************************************
     */
    public function buscaChamados($valor, $sistema, $data, $status, $todos) {
        return $this->contHelpDesk->buscaChamados($valor, $sistema, $data, $status, $todos);
    }

    public function getChamados($codigo) {
        return $this->contHelpDesk->getChamados($codigo);
    }

    public function getMensagens($codigo) {
        return $this->contHelpDesk->getMensagens($codigo);
    }

    public function meusChamados($responsavel, $assunto, $status, $data, $todos) {
        return $this->contHelpDesk->meusChamados($responsavel, $assunto, $status, $data, $todos);
    }

    public function buscaChamadosUsuario($usuario, $assunto, $status, $data, $todos) {
        return $this->contHelpDesk->buscaChamadosUsuario($usuario, $assunto, $status, $data, $todos);
    }

    /**
     * ***** Interessados ******************************************************
     */
    public function buscarInteressados($nome, $tipo, $sistema) {
        return $this->contInteressados->buscarInteressados($nome, $tipo, $sistema);
    }

}

?>
