<?php

require_once 'modelos/Informacoes.class.php';
require_once 'modelos/UsuarioTemp.class.php';
require_once 'GerenciadorABS.class.php';

/**
 * Description of GerenciadorUsuario
 *
 * @author Eticons
 */
class GerenciadorUsuario extends GerenciadorABS {

    private $listaUsuarios;
    private $cidade;

    public function logar($login, $senha) {
        if ($login != "" && $senha != "") {
            $usuarioLogadoSerial = new Usuario();
            $senha = $this->getMd5($senha);
            $usuarioLogadoSerial = $this->fachada->logar($login, $senha);
            if ($usuarioLogadoSerial != null) {
                $this->servico->setObjeto("nivel", $usuarioLogadoSerial->getNivel());
                $this->servico->setObjeto("usuarioCliente", $usuarioLogadoSerial->getNome());
                $this->servico->setObjeto("usuarioLogadoSerial", serialize($usuarioLogadoSerial));
                header("location: inicio.php");
            } else {
                $this->servico->setMessage("Usurio ou Senha esto incorretos!", 1);
                header('location: ' . $_SERVER['HTTP_REFERER']);
            }
        } else {
            die("Error ao logar");
        }
    }

    public function sair() {
        $this->servico->destroyObjeto("nivel");
        $this->servico->destroyObjeto("usuario");
        $this->servico->destroyObjeto("usuarioLogadoSerial");
        $this->servico->setMessage("Voc saiu do sistema!", 2);
        //header("location: ../logineticons.php");
        header("location: login.php");
    }

    public function buscaCep($cep) {
        $cep = str_replace("-", "", $cep);
        $resultado = @file_get_contents('http://cep.republicavirtual.com.br/web_cep.php?cep=' . urlencode($cep) . '&formato=query_string');
        parse_str($resultado, $retorno);
        $cepWS = new CepWS();
        if (!empty($retorno)) {
            $cepWS->cidade = $retorno['cidade'];
            $cepWS->bairro = $retorno['bairro'] != "" ? $retorno['bairro'] : 'Centro';
            $cepWS->uf = $retorno['uf'];
        }
        return $cepWS;
    }

    public function cadastrarUsuario($nome, $login, $senha, $cep, $cidade, $uf, $bairro, $email, $telefone, $tipoInst, $instituicao) {
		$usuario = new UsuarioTemp();
        $usuario->setNome(utf8_decode($nome));
        $usuario->setUsuario(utf8_decode($login));
        $usuario->setSenha($this->getMd5($senha));
        $usuario->setCep($cep);
        $usuario->setCidade(utf8_decode($cidade));
        $usuario->setUf($uf);
        $usuario->setBairro(utf8_decode($bairro));
        $usuario->setEmail(utf8_decode(strtolower($email)));
        $usuario->setTelefone($telefone);
        $usuario->setTipoInst(utf8_decode($tipoInst));
        $usuario->setInstituicao(utf8_decode($instituicao));
        $usuario->setDataSolicitacao(@date('Y/m/d H:i:s'));
        
		if ($this->verificarLogin($usuario->getUsuario())) {
            $retorno = $this->fachada->salvar($usuario);
            
			if ($retorno != 0) {
                $this->servico->setMessage("Usurio salvo com sucesso!", 2);
                $this->enviarEmail('suporte@e-ticons.com.br', '<h3>Um novo usurio se cadastrou e est esperando sua LIBERAO.</h3><div>Por favor acessar: <a href="http://www.e-ticons.com.br/cliente">www.e-ticons.com.br/cliente</a></div>', 'Novo Usurio para Liberao');
                header('location: ' . $_SERVER['HTTP_REFERER']);
            } else {
                $this->servico->setMessage("No foi possivel salvar este usurio!", 3);
                header('location: ' . $_SERVER['HTTP_REFERER']);
            }
        } else {
            $this->servico->setMessage("Este login j existe, por favor tente outro Login!", 3);
            header('location: ' . $_SERVER['HTTP_REFERER']);
        }
    }
	
	public function alteraUsuario($id, $nome, $cep, $cidade, $uf, $bairro, $email, $telefone, $tipoInst, $instituicao) {
        $usuario = new Usuario();
		$usuario->setId($id);
        $usuario->setNome(utf8_decode($nome));
        $usuario->setCep($cep);
        $usuario->setCidade(utf8_decode($cidade));
        $usuario->setUf($uf);
        $usuario->setBairro(utf8_decode($bairro));
        $usuario->setEmail(utf8_decode(strtolower($email)));
        $usuario->setTelefone($telefone);
        $usuario->setTipoInst(utf8_decode($tipoInst));
        $usuario->setInstituicao(utf8_decode($instituicao));
		
        if ($this->verificarLogin($usuario->getUsuario())) {
            $retorno = $this->fachada->alterar($usuario);
            $this->servico->setMessage("Usurio alterado com sucesso!", 2);
            header('location: ' . $_SERVER['HTTP_REFERER']);
        } else {
            $this->servico->setMessage("Este Login j existe, por favor tente outro Login!", 3);
            header('location: ' . $_SERVER['HTTP_REFERER']);
        }
    }

    public function verificaLogin($login) {
        $resultado = $this->fachada->verificaLogin($login);
        if ($resultado > 0) {
            echo utf8_encode("Este login j existe, por favor tente outro login!");
        }
    }

    public function verificarLogin($login) { 
        $resultado = $this->fachada->verificaLogin($login);
        
		if ($resultado > 0) {
            return false;
        }
		
        return true;
    }

    public function buscarUsuarios($valor, $tipo, $situacao, $todos) {
        $this->listaUsuarios = $this->fachada->buscarUsuarios($tipo, $valor, $situacao, $todos);
        return $this->listaUsuarios;
    }

    public function detalharUsuario($id) {
        $usuario = $this->fachada->obterUsuarioId($id);
        return $usuario;
    }

    public function detalharUsuarioTemp($id) {
        $usuario = $this->fachada->find(new UsuarioTemp(), $id);
        return $usuario;
    }

    public function recusarUsuario($id) {
        $usuarioTemp = new UsuarioTemp();
        $usuarioTemp->setId($id);
        $this->fachada->deletar($usuarioTemp);
        $this->servico->setMessage("Usurio recusado com sucesso!", 2);
        header("location: solicitantes.php");
    }

    public function aceitarUsuario($id, $nivel) {
        $usuarioTemp = $this->fachada->find(new UsuarioTemp(), $id);
        $usuario = new Usuario();
        if ($usuarioTemp != null) {
            $usuario->setNivel($nivel);
            $usuario->setBairro($usuarioTemp->getBairro());
            $usuario->setCep($usuarioTemp->getCep());
            $usuario->setCidade($usuarioTemp->getCidade());
            $usuario->setEmail($usuarioTemp->getEmail());
            $usuario->setInstituicao($usuarioTemp->getInstituicao());
            $usuario->setNome($usuarioTemp->getNome());
            $usuario->setSenha($usuarioTemp->getSenha());
            $usuario->setStatus("Ativo");
            $usuario->setTelefone($usuarioTemp->getTelefone());
            $usuario->setTipoInst($usuarioTemp->getTipoInst());
            $usuario->setUf($usuarioTemp->getUf());
            $usuario->setUsuario($usuarioTemp->getUsuario());
            $retorno = $this->fachada->salvar($usuario);
            if ($retorno != null) {
                $this->fachada->deletar($usuarioTemp);
                $this->servico->setMessage("Usurio liberado com sucesso!", 2);
                if ($usuario->getEmail() != "" && $usuario->getEmail() != NULL) {
                    $this->enviarEmail($usuario->getEmail(), "<h4>Seu cadastro foi liberado com sucesso!</h4>Voc j pode usar sua conta para baixar verses e instalaes dos sistemas,<br/>enviar sugestes, dentre outros servios.<p>Acesse sua conta <a href=\"http://e-ticons.com.br/login.php\">aqui!</a></p>", "Cadastro Liberado");
                }
                header("location: solicitantes.php");
            } else {
                $this->servico->setMessage("No foi possivel liberar este usurio!", 3);
                header("location: solicitantes.php");
            }
        }
    }

    public function alterarConta($id, $nome, $cep, $cidade, $uf, $bairro, $email, $telefone, $tipoInst, $instituicao) {
        $usuario = new Usuario();
        $usuario->setId($id);
        $usuario->setNome(utf8_decode($nome));
        $usuario->setCep($cep);
        $usuario->setCidade(utf8_decode($cidade));
        $usuario->setUf($uf);
        $usuario->setBairro(utf8_decode($bairro));
        $usuario->setEmail(utf8_decode($email));
        $usuario->setTelefone($telefone);
        $usuario->setTipoInst(utf8_decode($tipoInst));
        $usuario->setInstituicao(utf8_decode($instituicao));
        $this->fachada->alterar($usuario);
        $this->servico->setMessage("Sua conta foi alterada com sucesso!<br/>Efetue o login novamente para para visualizar suas alteraes", 2);
        header("location: configuracoes.php");
    }

    public function cancelarConta() {
        $usuario = unserialize($this->servico->getObjeto('usuarioLogadoSerial'));
        $usuario->setStatus("Inativo");
        $this->fachada->alterar($usuario);
        $this->servico->setMessage("Sua conta foi cancelada com sucesso!", 2);
        //header("location: ../logineticons.php");
        header("location: login.php");
    }

    public function alterarSenha($senhaAtual, $senhaNova) {
        $usuario = unserialize($this->servico->getObjeto('usuarioLogadoSerial'));
        if ($usuario->getSenha() == $this->getMd5($senhaAtual)) {
            $usuario->setSenha($this->getMd5($senhaNova));
            $this->fachada->alterar($usuario);
            $this->servico->setMessage("Sua senha foi alterada com sucesso!<br />Efetue novamente o login.", 2);
            header("location: configuracoes.php");
        } else {
            $this->servico->setMessage("Sua senha atual no confere com a senha digitada!", 3);
            header("location: configuracoes.php");
        }
    }

    public function solicitarSenha($login, $email) {
        $resultado = $this->fachada->verificaLogin($login);
		
        if ($resultado < 1) {
            $this->servico->setMessage("Este usurio no existe!", 3);
            header("location: /erro/");
        } else {
            $usuario = $this->fachada->verificaUsuario($login, $email);
			
            if ($usuario != null) {
                $novaSenha = $this->getValorRound();
                $usuario->setSenha($this->getMd5($novaSenha));
                $this->fachada->alterar($usuario);
                $mensagem = "<h3>Solicitao de senha recebida com sucesso em nossso sistema!</h3>Sua nova senha: " + $novaSenha;
                $this->enviarEmail($email, $mensagem, "Solicitao de senha");
                header("location: /feedback/");
            } else { 
                $this->servico->setMessage("Este usurio no possui um e-mail cadastrado! Para mais informaes contacte o administrador.", 1);
                header("location: /erro/");
            }
        }
    }

    public function getValorRound() {
        $i = 0;
        $str = "";
        while ($i < 15) {
            $num = rand(48, 122);
            if ((49 < $num && $num < 58 ) || ( 64 < $num && $num < 91 ) || ( 97 < $num && $num < 122 )) {
                $str .= chr($num);
                $i++;
            }
        }
        return $str;
    }

    public function enviarEmail($email, $mensagem, $assunto) {
        $para = $email;
        $headers = 'MIME-Version: 1.0' . "\r\n";
        $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
        $headers .= 'From: suporte@e-ticons.com.br' . "\r\n" . 'Reply-To: $email' . "\r\n" . 'X-Mailer: PHP/' . phpversion();
        mail($para, $assunto, $mensagem, $headers);
    }

    public function enviaEmail($email, $mensagem, $assunto) {
        $para = $email;
        $headers = 'MIME-Version: 1.0' . "\r\n";
        $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
        $headers .= 'From: suporte@e-ticons.com.br' . "\r\n" . 'Reply-To: $email' . "\r\n" . 'X-Mailer: PHP/' . phpversion();
        $remetente = unserialize($this->servico->getObjeto('usuarioLogadoSerial'));
        $mensagem = '<h3>E-mail do Suporte da E-TIcons</h3><p><strong>Remetente:</strong> ' . utf8_decode($remetente->getNome()) . '</p><strong>Mensagem:</strong> <div>' . utf8_decode($mensagem) . '</div>';
        if (mail($para, utf8_decode($assunto), $mensagem, $headers)) {
            $this->servico->setMessage("E-mail enviado com sucesso!", 2);
        } else {
            $this->servico->setMessage("Erro ao enviar o E-mail!", 3);
        }
        header('location: ' . $_SERVER['HTTP_REFERER']);
    }

    public function alterarUsuario($idUsuario, $statusUsuario) {
        $usuario = new Usuario();
        $usuario->setId($idUsuario);
        $usuario->setStatus($statusUsuario);
        $this->fachada->alterar($usuario);
        $this->servico->setMessage("Usurio alterado com sucesso!", 2);
        header('location: ' . $_SERVER['HTTP_REFERER']);
    }

    public function getInformacoes() {
        $informacoes = $this->fachada->getInformacoes();
        return $informacoes;
    }

    public function getUsuarios() {
        return $this->listaUsuarios;
    }

    private function getMd5($senha) {
        return md5($senha);
    }

    public function getUsuariosTemp() {
        $usuarios = $this->fachada->buscaGenerica("nome", "_", new UsuarioTemp());
        return $usuarios;
    }

    public function getCidade() {
        return $this->cidade;
    }

    public function setCidade($cidade) {
        $this->cidade = $cidade;
    }

    public function getUsuarioLogadoSerializado() {
        $usuarioLogadoSerial = unserialize($this->servico->getObjeto('usuarioLogadoSerial'));
        return $usuarioLogadoSerial;
    }

    public function getSistemas() {
        return $this->fachada->getSistemas();
    }

}

class CepWS {

    public $cidade;
    public $uf;
    public $bairro;

}

?>
