<?php

require_once 'modelos/Sugestoes.class.php';
require_once 'GerenciadorABS.class.php';

/**
 * Description of GerenciadorSugestos
 *
 * @author Bruno
 */
class GerenciadorSugestoes extends GerenciadorABS {

    public function cadastrarSugestao($texto) {
        $dataEnvio = date('Y/m/d H:i:s');
        $usuario = unserialize($this->servico->getObjeto("usuarioLogadoSerial"));
        $sugestao = new Sugestoes();
        $sugestao->setDataEnvio($dataEnvio);
        $sugestao->setTexto($texto);
        $sugestao->setUsuario($usuario->getId());
        $sugestao->setSituacao("0");
        $retorno = $this->fachada->salvar($sugestao);
        if ($retorno != 0) {
            $this->servico->setMessage("Sugesto salva com sucesso!", 2);
            header("location: cadastroSugestao.php");
        } else {
            $this->servico->setMessage("No foi possivel salvar esta sugesto!", 3);
            header("location: cadastroSugestao.php");
        }
    }

    public function buscarSugestoes($texto, $dataSugestao, $situacao) {
        if ($dataSugestao != "") {
            $dia = substr($dataSugestao, 0, 2);
            $mes = substr($dataSugestao, 3, 2);
            $ano = substr($dataSugestao, 6, 10);
            $dataSugestao = $ano . "-" . $mes . "-" . $dia;
        }
        $sugestoes = $this->fachada->buscarSugestoes($texto, $dataSugestao, $situacao);
        return $sugestoes;
    }

    public function getSugestoes() {
        $sugestoes = $this->fachada->getSugestoes();
        return $sugestoes;
    }

    public function excluirSugestao($id) {
        $sugestao = new Sugestoes();
        $sugestao->setId($id);
        $this->fachada->deletar($sugestao);
        $this->servico->setMessage("Sugesto deletada com sucesso!", 2);
        header("location: sugestoes.php");
    }

    public function alterarSugestao($id, $situacao) {
        $sugestao = new Sugestoes();
        $sugestao->setSituacao($situacao);
        $sugestao->setId($id);
        $this->fachada->alterar($sugestao);
        $this->servico->setMessage("Sugesto alterada com sucesso!", 2);
        header("location: sugestoes.php");
    }

}

?>
