<?php

require_once 'modelos/Comentarios.class.php';
require_once 'modelos/Sistema.class.php';
require_once 'GerenciadorABS.class.php';

/**
 * Description of GerenciadorSistemas
 *
 * @author Eticons
 */
class GerenciadorSistemas extends GerenciadorABS {

    private $sistemas;

    public function listaSistemas() {
        $this->sistemas = $this->fachada->getSistemas();
        if ($this->sistemas != null) {
            return $this->getSistemas();
        }
    }

    public function alterarSistema($id, $arquivo, $upload, $instalacao, $nome, $descricao, $versao, $comentario, $data, $imagem, $texto) {
        $coment = new Comentarios();
        $sistema = new Sistema();
        $data = @date('Y-m-d H:i:s');
        $sistema->setId($id);
        $sistema->setData($data);
        $sistema->setNome(utf8_decode($nome));
        $sistema->setInstalacao(utf8_decode($instalacao));
        $sistema->setDescricao(utf8_decode($descricao));
        $sistema->setVersao($versao);
        $sistema->setTexto(utf8_decode($texto));
		if (!empty($upload)) {
            $file = "../arquivos/" . basename($upload['name']);
            if (move_uploaded_file($upload['tmp_name'], $file)) {
                $sistema->setArquivo($upload['name']);
            } else {
                $this->servico->setMessage("Erro ao carregar o arquivo!", 3);
				 header("location: ".$_SERVER['HTTP_REFERER']);
            }
        } else {
        	$sistema->setArquivo(utf8_decode($arquivo));
		}
        if ($imagem != "") {
            $file = "../imagens/sistemas/" . basename($imagem['name']);
            if (move_uploaded_file($imagem['tmp_name'], $file)) {
                $sistema->setImagem($imagem['name']);
            } else {
                $this->servico->setMessage("Erro ao carregar a imagem!", 3);
                header("location: sistemas.php");
            }
        }
        $retorno = $this->fachada->alterar($sistema);
        if ($retorno != null) {
            if ($comentario != "") {
                $coment->setComentario(utf8_decode($comentario));
                $coment->setDataVersao($data);
                $coment->setIdSistema($id);
                $coment->setNomeSistema(utf8_decode($nome));
                $coment->setVersao($versao);
                $this->fachada->salvar($coment);
            }
            $this->servico->setMessage("Verso do sistema alterada com sucesso!", 2);
            header("location: ".$_SERVER['HTTP_REFERER']);
        } else {
            $this->servico->setMessage("No foi possivel alterar este Sistema!", 1);
            header("location: ".$_SERVER['HTTP_REFERER']);
        }
    }

    public function deletar($sistema) {
        $sist = new Sistema();
        $sist->setId($sistema);
        $result = $this->fachada->deletar($sist);
        if ($result != "") {
            $this->servico->setMessage("Sistema deletado com sucesso!", 2);
            header("location: sistemas.php");
        } else {
            $this->servico->setMessage("No foi possivel deletar este Sistema!", 1);
            header("location: sistemas.php");
        }
    }

    public function cadastrarSistema($arquivo, $nome, $instalacao, $descricao, $versao, $imagem, $texto) {
        $sistema = new Sistema();
        $data = date('Y-m-d H:i:s');
        $sistema->setData($data);
        $sistema->setDescricao(utf8_decode($descricao));
        $sistema->setNome(utf8_decode($nome));
        $sistema->setInstalacao(utf8_decode($instalacao));
        $sistema->setVersao($versao);
        $sistema->setTexto(utf8_decode($texto));
        if ($imagem != "") {
            $file = "../imagens/sistemas/" . basename($imagem['name']);
            if (move_uploaded_file($imagem['tmp_name'], $file)) {
                $sistema->setImagem($imagem['name']);
            } else {
                $this->servico->setMessage("Erro ao carregar a imagem!", 3);
                header("location: cadastroSistema.php");
            }
        }
        if (count($arquivo) > 1) {
            $file = "../arquivos/" . basename($arquivo['name']);
            if (move_uploaded_file($arquivo['tmp_name'], $file)) {
                $sistema->setArquivo($arquivo['name']);
            } else {
                $this->servico->setMessage("Erro ao carregar o arquivo!", 3);
                header("location: cadastroSistema.php");
            }
        } else {
            $sistema->setArquivo(utf8_decode($arquivo));
        }
        $retorno = $this->fachada->salvar($sistema);
        if ($retorno != null) {
            $this->servico->setMessage("Sistema salvo com sucesso!", 2);
            header("location: cadastroSistema.php");
        } else {
            $this->servico->setMessage("No foi possivel salvar este Sistema!", 3);
            header("location: cadastroSistema.php");
        }
    }

    public function getSistema($id) {
		settype($id, 'integer');
        $sistema = $this->fachada->getSistemaPorId($id);
        return $sistema;
    }

    public function getSistemas() {
        return $this->sistemas;
    }

    public function setSistemas($sistemas) {
        $this->sistemas = $sistemas;
    }
	
	public function obterArquivo($link){
		try{
			$stat = @stat($link);
			$arquivo = new Arquivo($link, $stat['size'], $stat['atime']);
			return $arquivo;
		} catch(Exception $ex){
			return new Arquivo();
		}
	}
}

class Arquivo{
	
	private $nome;
	private $tamanho;
	private $data;
	
	public function __construct($nome, $tamanho, $data) {
		$this->nome = $nome;
		$this->tamanho = $tamanho;
		$this->data = $data;
	}
	
	public function getNome(){
		return $this->nome;
	}
	
	public function getTamanho(){
		$sigla = 'Mb';
		$tam = $this->tamanho/(1024*1000);
		if($tam < 1){
			$tam = $this->tamanho/1024;
			$sigla = 'Kb';
		}
		$tam = number_format($tam, 3);
		return $tam.' '.$sigla;
	}
	
	public function getData(){
		$data = @date("d/m/Y H\hm", $this->data);
		return $data;
	}
	
	public function getTipo(){
		return substr($this->nome, (strlen($this->nome)-4), strlen($this->nome));
	}
}

?>
