<?php

require_once 'modelos/RegistrosAcessos.class.php';
require_once 'GerenciadorABS.class.php';

/**
 * Description of GerenciadorRegistros
 *
 * @author Eticons
 */
class GerenciadorRegistros extends GerenciadorABS {

    public function buscarRegistros($valor, $movimento, $dataAcesso, $todos) {
        if ($dataAcesso != "") {
            $dia = substr($dataAcesso, 0, 2);
            $mes = substr($dataAcesso, 3, 2);
            $ano = substr($dataAcesso, 6, 10);
            $dataAcesso = $ano . "-" . $mes . "-" . $dia;
        }
        $registros = $this->fachada->buscarRegistros(utf8_decode($valor), $movimento, $dataAcesso, $todos);
        return $registros;
    }

    public function getRegistro($id) {
        $registro = $this->fachada->getRegistro($id);
        return $registro;
    }

}

?>
