<?php

require_once 'modelos/Noticia.class.php';
require_once 'GerenciadorABS.class.php';

/**
 * @author Bruno
 */
class GerenciadorNoticias extends GerenciadorABS {

    public function cadastrarNoticia($titulo, $subtitulo, $texto, $data, $hora, $imagem) {
        $autor = unserialize($this->servico->getObjeto('usuarioLogadoSerial'));
        $noticia = new Noticia();
        $noticia->setAutor($autor->getId());
        $noticia->setTitulo(utf8_decode($titulo));
        $noticia->setSubtitulo(utf8_decode($subtitulo));
        $noticia->setTexto(utf8_decode($texto));
        $dataNoticia = $this->converteDataSql($data) . " " . $hora;
        $noticia->setDataNoticia($dataNoticia);
        if ($imagem != "") {
            $image = "imagemNoticia_". htmlspecialchars($noticia->getTitulo()) ."_" . str_replace("/", "-", $data) . substr($imagem['name'], strlen($imagem['name']) - 4, strlen($imagem['name']));
            if ($this->salvaImagem($imagem, $image)) {
                $noticia->setImagemUrl($image);
            }
        } else {
            $noticia->setImagemUrl("noticia_padrao.png");
        }
        $retorno = $this->fachada->salvar($noticia);

        if ($retorno != 0) {
            $this->servico->setMessage("Notcia salva com sucesso!", 2);
            header("location: cadastroNoticia.php");
        } else {
            $this->servico->setMessage("No foi possivel salvar esta Notcia!", 3);
            header("location: cadastroNoticia.php");
        }
    }

    public function buscarNoticia($valor, $dataNoticia) {
        $dataNoticia = ($dataNoticia != "" ? $this->converteDataSql($dataNoticia) : "");
        $noticias = $this->fachada->buscaNoticias($valor, $dataNoticia);
        return $noticias;
    }

    public function getNoticiaId($id) {
		settype($id, 'integer'); 
        $noticia = $this->fachada->find(new Noticia(), $id);
		
        return $noticia;
    }

    public function getNoticias() {
        $noticias = $this->fachada->getNoticias();
        return $noticias;
    }

    public function excluirNoticia($id) {
        $noticia = new Noticia();
        $noticia->setId($id);
        $resposta = $this->fachada->deletar($noticia);
        if ($resposta != "") {
            $this->servico->setMessage("Notcia deletada com sucesso!", 2);
            header("location: noticias.php");
        } else {
            $this->servico->setMessage("No foi possivel deletar esta Notcia!", 3);
            header("location: noticias.php");
        }
    }

    public function alterarNoticia($id, $titulo, $subtitulo, $texto, $data, $hora, $imagem) {
        $autor = unserialize($this->servico->getObjeto('usuarioLogadoSerial'));
        $noticia = new Noticia();
        $noticia->setId($id);
        $noticia->setAutor($autor->getId());
        $noticia->setTitulo(utf8_decode($titulo));
        $noticia->setSubtitulo(utf8_decode($subtitulo));
        $noticia->setTexto(utf8_decode($texto));
        $dataNoticia = $this->converteDataSql($data) . " " . $hora;
        $noticia->setDataNoticia($dataNoticia);
        if ($imagem != "") {
            $image = trim($noticia->getTitulo() . "_" . substr($noticia->getSubtitulo(), 0, 10) . "..._" . str_replace("/", "-", $data) . substr($imagem['name'], strlen($imagem['name']) - 4, strlen($imagem['name'])));
            if ($this->salvaImagem($imagem, $image)) {
                $noticia->setImagemUrl($image);
            }
        }
        $retorno = $this->fachada->alterar($noticia);
        $this->servico->setMessage("Notcia alterada com sucesso!", 2);
        header("location: noticias.php");
    }

    public function salvaImagem($imagem, $image) {
        $file = "noticias/" . $image;
        if (move_uploaded_file($imagem['tmp_name'], $file)) {
            return true;
        } else {
            $this->servico->setMessage("Erro ao carregar a imagem!");
            return false;
        }
    }

}

?>
