<?php

require_once 'modelos/Interessados.class.php';
require_once 'GerenciadorABS.class.php';

/**
 * Description of GerenciadorInteressados
 *
 * @author Eticons
 */
class GerenciadorInteressados extends GerenciadorABS {

    public function cadastrar($nome, $tipo, $email, $telefone, $celular, $endereco, $numero, $cep, $cidade, $uf, $bairro, $sistemas, $assunto, $texto) {
        $interessado = new Interessados();
        $interessado->setNome(utf8_decode($nome));
        $interessado->setTipo($tipo);
        $interessado->setEmail(utf8_decode($email));
        $interessado->setTelefone($telefone);
        $interessado->setCelular($celular);
        $interessado->setEndereco(utf8_decode($endereco));
        $interessado->setNumero($numero);
        $interessado->setCep($cep);
        $interessado->setCidade(utf8_decode($cidade));
        $interessado->setUf($uf);
        $interessado->setBairro(utf8_decode($bairro));
        $interessado->setAssunto(utf8_decode($assunto));
        $interessado->setMensagem(utf8_decode($texto));
        $interessado->setDataEnvio($this->converteDataSql(""));
        $systems = "";
        
		foreach ($sistemas as $sis) {
            $systems .= "<li>".utf8_decode($sis)."</li>";
            $interessado->setSistemas($systems);
        }
		
        $retorno = $this->fachada->salvar($interessado);
        
		if ($retorno > 0) {
            $this->servico->setMessage("Seu cadastro foi efetuado com sucesso!", 2);
        }
		
        header("location: /interessados/");
    }

    public function buscarInteressados($nome, $tipo, $sistema) {
        $interessados = $this->fachada->buscarInteressados(utf8_decode($nome), $tipo, utf8_decode($sistema));
        return $interessados;
    }

    public function excluirInteressado($id) {
        $inter = new Interessados();
        $inter->setId($id);
        $this->fachada->deletar($inter);
        $this->servico->setMessage("Interessado excludo com sucesso!", 2);
        header("location: interessados.php");
    }

    public function getInteressado($id) {
        $inter = $this->fachada->find(new Interessados(), $id);
        return $inter;
    }

}

?>
