<?php

require_once 'modelos/Chamados.class.php';
require_once 'modelos/Mensagem.class.php';
require_once 'modelos/Sistema.class.php';
require_once 'modelos/Cliente.class.php';
require_once 'GerenciadorABS.class.php';

/**
 * Description of GerenciadorHelpDesk
 *  status : 1-novo, 2-recebido, 3-finalizado,4-cancelado, 5-pendente, 6-andamento
 * @author Eticons
 */
class GerenciadorHelpDesk extends GerenciadorABS {

    public function cadastrarChamado($email, $instituicao, $sistema, $assunto, $mensagem) {
        $usuario = unserialize($this->servico->getObjeto("usuarioLogadoSerial"));
        $data = date('Y/m/d H:i:s');
        $chamado = new Chamados();
        $chamado->setAssunto($assunto);
        $chamado->setDataEnvio($data);
        $chamado->setSistema($sistema);
        $chamado->setUsuario($usuario->getId());
        $chamado->setStatusChamado(1);
        $cliente = $this->fachada->buscaGenerica("cnpjCpf", $this->retiraCaracteres($instituicao), new Cliente());
        $chamado->setCliente($cliente[0]->getId());
        $retorno = $this->fachada->salvar($chamado);
        if ($retorno > 0) {
            $msg = new Mensagem();
            $msg->setChamado($retorno);
            $msg->setDataResposta($data);
            $msg->setMensagem($mensagem);
            $msg->setRemetente($usuario->getNome());
            $this->fachada->salvar($msg);
            $this->servico->setMessage("Chamado enviado com sucesso!<br />Dentro de alguns instantes voc receber um email informando o status do seu chamado.", 2);
        }
        header("location: ajuda.php");
    }

    public function getSistemas() {
        $sistemas = $this->fachada->getSistemas();
        return $sistemas;
    }

    public function buscaChamados($valor, $sistema, $data, $status, $todos) {
        $data = ($data != "" ? $this->converteDataSql($data) : "");
        $chamados = $this->fachada->buscaChamados($valor, $sistema, $data, $status, $todos);
        return $chamados;
    }

    public function retiraCaracteres($valor) {
        $caracteres = array(".", "-", "/", ",");
        $campo = str_replace($caracteres, "", $valor);
        return $campo;
    }

    public function getChamado($codigo) {
        $chamados = $this->fachada->getChamados($codigo);
        $chamado = $chamados[0];
        return $chamado;
    }

    public function getMensagem($codigo) {
        $mensagens = $this->fachada->getMensagens($codigo);
        $mensagem = $mensagens[0];
        return $mensagem;
    }

    public function addResposta($chamado, $mensagem, $status) {
        $responsavel = $this->servico->getObjeto("usuarioRestritoLogado");
        $ch = new Chamados();
        $ch->setCodigo($chamado);
        $ch->setResponsavel($responsavel->getId());
        $ch->setStatusChamado($status == "1" ? "2" : $status);
        $this->fachada->alterar($ch);
        $msg = new Mensagem();
        $msg->setChamado($chamado);
        $msg->setDataResposta(date('Y/m/d H:i:s'));
        $msg->setMensagem($mensagem);
        $msg->setRemetente($responsavel->getNome());
        $this->fachada->salvar($msg);
        //enviar um email
        $this->enviarEmail($email, "Caro usurio,<p>Foi respondido um de seus chamados do site da e-TIcons, por favor verifique!</p>", "Responderam ao seu chamado.");
        $this->servico->setMessage("Resposta enviada com sucesso!", 2);
        header("location: " . $_SERVER['HTTP_REFERER']);
    }

    public function meusChamados($assunto, $status, $data, $todos) {
        $responsavel = unserialize($this->servico->getObjeto("usuarioRestritoLogadoSerializado"));
        $chamados = $this->fachada->meusChamados($responsavel->getId(), $assunto, $status, $data, $todos);
        return $chamados;
    }

    public function getMensagens($codigo) {
        $mensagens = $this->fachada->getMensagens($codigo);
        return $mensagens;
    }

    public function buscaChamadosUsuario($assunto, $status, $data, $todos) {
        $usuario = unserialize($this->servico->getObjeto("usuarioLogadoSerial"));
        $data = ($data != "" ? $this->converteDataSql($data) : "");
        $chamados = $this->fachada->buscaChamadosUsuario($usuario->getId(), $assunto, $status, $data, $todos);
        return $chamados;
    }

    public function addRespostaUsuario($chamado, $mensagem, $status) {
        $usuario = unserialize($this->servico->getObjeto("usuarioLogadoSerial"));
        $ch = new Chamados();
        $ch->setCodigo($chamado);
        $ch->setStatusChamado($status);
        $this->fachada->alterar($ch);
        $msg = new Mensagem();
        $msg->setChamado($chamado);
        $msg->setDataResposta(date('Y/m/d H:i:s'));
        $msg->setMensagem($mensagem);
        $msg->setRemetente($usuario->getNome());
        $this->fachada->salvar($msg);
        $this->servico->setMessage("Resposta enviada com sucesso!", 2);
        header("location: " . $_SERVER['HTTP_REFERER']);
    }

    public function enviarEmail($email, $mensagem, $assunto) {
        $para = $email;
        $headers = 'MIME-Version: 1.0' . "\r\n";
        $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
        $headers .= 'From: suporte@e-ticons.com.br' . "\r\n" . 'Reply-To: $email' . "\r\n" . 'X-Mailer: PHP/' . phpversion();
        mail($para, $assunto, $mensagem, $headers);
    }

}

?>
