<?php

require_once 'modelos/Sistema.class.php';
require_once 'modelos/Cliente.class.php';
require_once 'modelos/ClienteSistema.class.php';
require_once 'modelos/RegistrosAcessos.class.php';
require_once 'GerenciadorABS.class.php';

/**
 * Description of GerenciadorClientes
 *
 * @author Eticons
 */
class GerenciadorClientes extends GerenciadorABS {

    public function buscarClientes($valor, $instituicao, $liberado, $status, $todos) {
        $clientes = $this->fachada->buscarClientes(utf8_decode($valor), utf8_decode($instituicao), $liberado, $status, $todos);
        return $clientes;
    }
	
	public function buscarClientesPorSistema($sistema, $cnpj) {
		if($cnpj == NULL){ $cnpj = "%"; }
        $clientes = $this->fachada->buscarClientesPorSistema($sistema, $cnpj);
        return $clientes;
    }

    /**
     * Este metodo atualiza todos os clientes, atravs de um TXT
     * @param <type> $arquivo
     */
    public function atualizarGeral($arquivo) {
        $tipo = strtolower(substr($arquivo['name'], strlen($arquivo['name']) - 3, 3));
        if ($arquivo != "" && $tipo == "txt") {
            $file = "controle/atualizacao/" . @date('d-m-Y') . basename($arquivo['name']);
            if (move_uploaded_file($arquivo['tmp_name'], $file)) {
                $txt = $file;
                $fp = @fopen($txt, 'r');
                if (filesize($txt) > 0) {
                    $texto = fread($fp, filesize($txt));
                    fclose($fp);
                    $result = explode(';', $texto);
                    $clientes = $result[0];
                    for ($i = 4; $i < (count($result) - 1); $i+=4) {
                        $clientes.=", " . $result[$i];
                    }
                    $this->fachada->atualizaTodosClientes($clientes);
                    $this->registrarMovimento(1000, "Atualizou por TXT", NULL, NULL, NULL);
                    $this->servico->setMessage("Clientes atualizados com sucesso!", 2);
                    header("location: controle/atualizacaoClientesTXT.php");
                } else {
                    $this->servico->setMessage("Arquivo vazio!", 1);
                    header("location: controle/atualizacaoClientesTXT.php");
                }
            } else {
                $this->servico->setMessage("Erro ao atualizar os clientes!", 3);
                header("location: controle/atualizacaoClientesTXT.php");
            }
        } else {
            $this->servico->setMessage("Este arquivo no  um TXT!", 3);
            header("location: controle/atualizacaoClientesTXT.php");
        }
    }

    public function bloquearTodos($sistemas) {
        if ($sistemas != "") {
            $this->fachada->bloqueiaTodosClientes($sistemas);
            $detalhes = "";
            $lista = $this->getListaSistemas();
            foreach ($sistemas as $sis) {
                foreach ($lista as $s) {
                    if ($s->getId() == $sis) {
                        $detalhes .= "<div><strong>Sistema: </strong>" . $s->getNome() . "</div>";
                    }
                }
            }
            $this->registrarMovimento(1000, "Bloqueou todos", NULL, NULL, $detalhes);
            $this->servico->setMessage("Sistemas bloqueados com sucesso!", 2);
            header("location: controle/bloquearTodos.php");
        } else {
            $this->servico->setMessage("Selecione ao menos um sistema ou todos!", 1);
            header("location: controle/bloquearTodos.php");
        }
    }

    public function liberarTodos($sistemas) {
        if ($sistemas != "") {
            $this->fachada->liberaTodosClientes($sistemas);
            $detalhes = "";
            $lista = $this->getListaSistemas();
            foreach ($sistemas as $sis) {
                foreach ($lista as $s) {
                    if ($s->getId() == $sis) {
                        $detalhes .= "<div><strong>Sistema: </strong>" . $s->getNome() . "</div>";
                    }
                }
            }
            $this->registrarMovimento(1000, "Liberou todos", NULL, NULL, $detalhes);
            $this->servico->setMessage("Sistemas liberados com sucesso!", 2);
            header("location: controle/liberarTodos.php");
        } else {
            $this->servico->setMessage("Selecione ao menos um sistema ou todos!", 1);
            header("location: controle/liberarTodos.php");
        }
    }

    public function getCliente($id) {
        return $this->fachada->find(new Cliente(), $id);
    }

    public function getListaSistemas() {
        $sistemas = $this->fachada->getSistemas();
        return $sistemas;
    }

    public function getSistemas($idCliente) {
        if ($idCliente != "") {
            $sistemas = $this->fachada->getClienteSistemas($idCliente);
            return $sistemas;
        }
        return array();
    }

    public function cadastrarCliente($nome, $cnpjCpf, $validado, $tipoInstituicao, $razao, $nomeFantasia, $liberado, $status, $sistemas, $dataImplantacao, $contador, $responsavel) {
        $dataBloqueio = @date('mY');
        $cliente = new Cliente();
        $cliente->setNome(utf8_decode($nome));
        $cliente->setCnpjCpf($this->retiraCaracteres($cnpjCpf));
        $cliente->setCnpjCpfValidado($validado);
        $cliente->setTipoInstituicao(utf8_decode($tipoInstituicao));
        $cliente->setRazao(utf8_decode($razao));
        $cliente->setNomeFantasia(utf8_decode($nomeFantasia));
        $cliente->setLiberado($liberado);
        $cliente->setStatus($status);
        $cliente->setDataBloqueio($dataBloqueio);
        if ($this->verificarCliente($cliente->getCnpjCpf())) {
            $resposta = $this->fachada->salvar($cliente);
            if ($resposta != 0) {
                foreach ($sistemas as $sis) {
                    $clienteSistema = new ClienteSistema();
                    $clienteSistema->setDataBloqueio($dataBloqueio);
                    $clienteSistema->setData_implantacao($this->converteDataSql($dataImplantacao));
                    $clienteSistema->setId_cliente($resposta);
                    $clienteSistema->setId_sistema($sis);
                    $clienteSistema->setLiberado("S");
                    $clienteSistema->setContador(utf8_decode($contador));
                    $clienteSistema->setResponsavel(utf8_decode($responsavel));
                    $this->fachada->salvar($clienteSistema);
                }
                //registrando o movimento
                $this->registrarMovimento($resposta, "Cadastrou", NULL, NULL, NULL);
                $this->servico->setMessage("Cliente cadastrado com sucesso!", 2);
                header('location: controle/cadastroCliente.php');
            } else {
                $this->servico->setMessage("No foi possivel cadastrar este cliente!", 3);
                header('location: controle/cadastroCliente.php');
            }
        } else {
            $this->servico->setMessage("No foi possvel cadastrar este cliente, porque este CNPJ/CPF j existe!", 1);
            header('location: controle/cadastroCliente.php');
        }
    }

    public function alterarCliente($id, $nome, $cnpjCpf, $cnpjCpfAtual, $validado, $tipoInstituicao, $razao, $nomeFantasia, $liberado, $status, $sistemas, $dataImplantacao, $contador, $responsavel) {
        $dataBloqueio = (strtolower($status) == "inativo" ? $this->getDataBloqueio() : NULL);
        $cliente = new Cliente();
        $cliente->setId($id);
        $cliente->setNome(utf8_decode($nome));
        $cnpjCpf = $this->retiraCaracteres($cnpjCpf);
        $cliente->setCnpjCpf($cnpjCpf);
        $cliente->setCnpjCpfValidado($validado);
        $cliente->setTipoInstituicao(utf8_decode($tipoInstituicao));
        $cliente->setRazao(utf8_decode($razao));
        $cliente->setNomeFantasia(utf8_decode($nomeFantasia));
        $cliente->setLiberado($liberado);
        $cliente->setStatus($status);
        $cliente->setDataBloqueio($dataBloqueio);
        $clienteLiberado = ($cnpjCpfAtual == $cnpjCpf ? true : $this->verificarCliente($cliente->getCnpjCpf()));
        if ($clienteLiberado) {
            $clienteAntigo = $this->fachada->find(new Cliente(), $id);
            $this->fachada->alterar($cliente);
            $sistemasAtuais = $this->getSistemas($id);
            $detalhesAlterados = "";
            foreach ($sistemasAtuais as $sisAtual) {
                $remove = true;
                $key = array_search($sisAtual->getId_sistema(), $sistemas);
                if ($key > -1) {//verifica se o sistema atual ainda est na lista nova
                    $remove = false;
                }
                if ($remove) {
                    $detalhesAlterados .= "<div><strong>Sistema:</strong> deletou: <span>" . $sisAtual->getNomeSistema() . "</span></div>";
                    $this->fachada->deletar($sisAtual);
                }
            }
            foreach ($sistemas as $sisNovo) {
                $clienteSistema = new ClienteSistema();
                $clienteSistema->setId_cliente($id);
                $clienteSistema->setId_sistema($sisNovo);
                $clienteSistema->setLiberado("S");
                $clienteSistema->setDataBloqueio(strtolower($status) == "inativo" ? $this->getDataBloqueio() : @date('mY'));
                $clienteSistema->setData_implantacao($this->converteDataSql($dataImplantacao));
                $clienteSistema->setContador(utf8_decode($contador));
                $clienteSistema->setResponsavel(utf8_decode($responsavel));
                if ($this->verificarClienteSistema($clienteSistema)) {
                    $this->fachada->salvar($clienteSistema);
                    $detalhesAlterados .= "<div><strong>Sistema:</strong> salvou: <span>" . $sisNovo . "</span>, contador: <span>" . $contador . "</span>, responsvel: <span>" . $responsavel . "</span></div>";
                } else {
                    $this->fachada->alterar($clienteSistema);
                    $detalhesAlterados .= "<div><strong>Sistema:</strong> alterou: <span>" . $sisNovo . "</span>, contador: <span>" . $contador . "</span>, responsvel: <span>" . $responsavel . "</span></div>";
                }
            }
            //registrando o movimento
            $detalhes = $detalhesAlterados . $this->montaAlteracoes($cliente, $clienteAntigo);
            $this->registrarMovimento($id, "Alterou", NULL, NULL, $detalhes);
            $this->servico->setMessage("Cliente alterado com sucesso!", 2);
            header('location: ' . $_SERVER['HTTP_REFERER']);
        } else {
            $this->servico->setMessage("No foi possvel alterar este cliente, porque este CNPJ/CPF j existe!", 3);
            header('location: ' . $_SERVER['HTTP_REFERER']);
        }
    }

    public function montaAlteracoes($clienteNovo, $clienteAntigo) {
        $alteracoes = array();
        if ($clienteNovo->getNome() != $clienteAntigo->getNome()) {
            array_push($alteracoes, "<div><strong>Nome:</strong> de: <span>" . $clienteAntigo->getNome() . "</span>, para: <span>" . $clienteNovo->getNome() . "</span></div>");
        }
        if ($clienteNovo->getCnpjCpf() != $clienteAntigo->getCnpjCpf()) {
            array_push($alteracoes, "<div><strong>CnpjCpf:</strong> de: <span>" . $clienteAntigo->getCnpjCpf() . "</span>, para: <span>" . $clienteNovo->getCnpjCpf() . "</span></div>");
        }
        if ($clienteNovo->getTipoInstituicao() != $clienteAntigo->getTipoInstituicao()) {
            array_push($alteracoes, "<div><strong>TipoInstituicao:</strong> de: <span>" . $clienteAntigo->getTipoInstituicao() . "</span>, para: <span>" . $clienteNovo->getTipoInstituicao() . "</span></div>");
        }
        if ($clienteNovo->getLiberado() != $clienteAntigo->getLiberado()) {
            array_push($alteracoes, "<div><strong>Liberado:</strong> de: <span>" . $clienteAntigo->getLiberado() . "</span>, para: <span>" . $clienteNovo->getLiberado() . "</span></div>");
        }
        if ($clienteNovo->getStatus() != $clienteAntigo->getStatus()) {
            array_push($alteracoes, "<div><strong>Status:</strong> de: <span>" . $clienteAntigo->getStatus() . "</span>, para: <span>" . $clienteNovo->getStatus() . "</span></div>");
        }
        if ($clienteNovo->getDataBloqueio() != $clienteAntigo->getDataBloqueio()) {
            array_push($alteracoes, "<div><strong>Data bloqueio:</strong> de: <span>" . $clienteAntigo->getDataBloqueio() . "</span>, para: <span>" . $clienteNovo->getDataBloqueio() . "</span></div>");
        }
        if ($clienteNovo->getRazao() != $clienteAntigo->getRazao()) {
            array_push($alteracoes, "<div><strong>Razo social:</strong> de: <span>" . $clienteAntigo->getRazao() . "</span>, para: <span>" . $clienteNovo->getRazao() . "</span></div>");
        }
        if ($clienteNovo->getNomeFantasia() != $clienteAntigo->getNomeFantasia()) {
            array_push($alteracoes, "<div><strong>Nome fantasia:</strong> de: <span>" . $clienteAntigo->getNomeFantasia() . "</span>, para: <span>" . $clienteNovo->getNomeFantasia() . "</span></div>");
        }
        return implode("", $alteracoes);
    }

    public function retiraCaracteres($valor) {
        $caracteres = array(".", "-", "/", ",");
        $campo = str_replace($caracteres, "", $valor);
        return $campo;
    }

    public function verificarCliente($cnpj) {
        $resultado = $this->fachada->verificaCliente($cnpj);
        if ($resultado != NULL) {
            return false;
        }
        return true;
    }

    public function verificaClienteSerializado($cnpj) {
        if (strpos($cnpj, ".") > -1) {
            $cnpj = $this->retiraCaracteres($cnpj);
        }
        $resultado = $this->fachada->verificaCliente($cnpj);
        if ($resultado != NULL) {
            echo json_encode(array("resposta" => "true", "instituicao" => $resultado->getNome()));//"CLIENTE OK";
        } else {
            echo json_encode(array("resposta" => "false"));//utf8_encode("CLIENTE INVLIDO");
        }
    }

    public function verificarClienteSistema($clienteSistema) {
        $resultado = $this->fachada->verificaClienteSistema($clienteSistema);
        if ($resultado > 0) {
            return false;
        }
        return true;
    }

    public function inativarCliente($id) {
        $cliente = new Cliente();
        $cliente->setId($id);
        $cliente->setStatus("Inativo");
        $cliente->setLiberado("N");
        $this->fachada->alterar($cliente);

        $clienteSistema = new ClienteSistema();
        $clienteSistema->setDataBloqueio($this->getDataBloqueio());
        $clienteSistema->setId_cliente($id);
        $clienteSistema->setLiberado("N");
        $this->fachada->alterar($clienteSistema);
        //registrando o movimento
        $this->registrarMovimento($id, "Inativou", NULL, NULL, NULL);
        $this->servico->setMessage("Cliente inativado com sucesso!", 2);
        header('location: ' . $_SERVER['HTTP_REFERER']);
    }

    public function ativarCliente($id, $liberado) {
        $cliente = new Cliente();
        $cliente->setId($id);
        $cliente->setStatus("Ativo");
        $cliente->setLiberado($liberado);
        $this->fachada->alterar($cliente);

        $clienteSistema = new ClienteSistema();
        $dataBloqueio = @date('mY');
        $clienteSistema->setDataBloqueio($dataBloqueio);
        $clienteSistema->setId_cliente($id);
        $clienteSistema->setLiberado($liberado);
        $this->fachada->alterar($clienteSistema);
        //registrando o movimento
        $this->registrarMovimento($id, "Ativou", NULL, NULL, NULL);
        $this->servico->setMessage("Cliente ativado com sucesso!", 2);
        header('location: ' . $_SERVER['HTTP_REFERER']);
    }

    public function liberarCliente($id, $motivo) {
        $dataBloqueio = @date('mY');
        $cliente = new Cliente();
        $cliente->setId($id);
        $cliente->setDataBloqueio($dataBloqueio);
        $cliente->setLiberado("S");
        $this->fachada->alterar($cliente);

        $clienteSistema = new ClienteSistema();
        $clienteSistema->setDataBloqueio($dataBloqueio);
        $clienteSistema->setId_cliente($id);
        $clienteSistema->setLiberado("S");
        $this->fachada->alterar($clienteSistema);
        //registra o movimento
        $this->registrarMovimento($id, "Liberou", $motivo, NULL, NULL);
        $this->servico->setMessage("Cliente liberado com sucesso!", 2);
        header('location: ' . $_SERVER['HTTP_REFERER']);
    }

    public function bloquearCliente($id) {
        $dataBloqueio = $this->getDataBloqueio();
        $cliente = new Cliente();
        $cliente->setId($id);
        $cliente->setDataBloqueio($dataBloqueio);
        $cliente->setLiberado("N");
        $this->fachada->alterar($cliente);

        $clienteSistema = new ClienteSistema();
        $clienteSistema->setDataBloqueio($dataBloqueio);
        $clienteSistema->setId_cliente($id);
        $clienteSistema->setLiberado("N");
        $this->fachada->alterar($clienteSistema);
        //registra o movimento
        $this->registrarMovimento($id, "Bloqueou", NULL, NULL, NULL);
        $this->servico->setMessage("Cliente bloqueado com sucesso!", 2);
        header('location: ' . $_SERVER['HTTP_REFERER']);
    }

    public function liberarSistema($cliente, $sistema, $motivo) {
        $cli = new Cliente();
        $cli->setId($cliente);
        $cli->setLiberado("S");
        $this->fachada->alterar($cli);
        $clienteSistema = new ClienteSistema();
        $clienteSistema->setDataBloqueio(@date('mY'));
        $clienteSistema->setId_cliente($cliente);
        $clienteSistema->setId_sistema($sistema);
        $clienteSistema->setLiberado("S");
        $this->fachada->alterar($clienteSistema);
        $this->registrarMovimento($cliente, "Liberou", $motivo, $sistema, NULL);
    }

    public function bloquearSistema($cliente, $sistema) {
        $clienteSistema = new ClienteSistema();
        $clienteSistema->setId_cliente($cliente);
        $clienteSistema->setId_sistema($sistema);
        $clienteSistema->setLiberado("N");
        $clienteSistema->setDataBloqueio($this->getDataBloqueio());
        $this->fachada->alterar($clienteSistema);
        $this->registrarMovimento($cliente, "Bloqueou", NULL, $sistema, NULL);
    }

    public function registrarMovimento($cliente, $movimento, $obs, $sistema, $detalhes) {
        $registro = new RegistrosAcessos();
        $usuario = $this->servico->getObjeto('usuarioRestritoLogado');
        $registro->setDataAcesso(@date('Y-m-d H:i:s'));
        $registro->setIdCliente($cliente);
        $registro->setIdUsuarioRestrito($usuario->getId());
        $registro->setMovimento($movimento);
        $registro->setObs($obs);
        $registro->setSistema($sistema);
        $registro->setDetalhes($detalhes);
        $this->fachada->salvar($registro);
        $this->atualizaArquivoClientesJson();
    }

    public function atualizaArquivoClientesJson() {
        $clientes = $this->fachada->getClientesParaArquivo();
        $arquivo['nome'] = "clientesJson.json";
        $json = "[";
        if (!empty($clientes)) {
            foreach ($clientes as $cliente) {
                $objeto = var_export($cliente, TRUE);
                $json .= json_encode($cliente->toArquivo()) . ",";
            }
            $json .= "]";
        }
        $arquivo['conteudo'] = str_ireplace(",]", "]", $json);
        $this->alteraArquivoJson($arquivo);
    }

    public function alteraArquivoJson($arquivo) {
        $pasta = "controle/arquivos/";
        //2-salva novo
        file_put_contents($pasta . $arquivo['nome'], $arquivo['conteudo']);
    }

    public function getDataBloqueio() {
        $mes = (@date('m') - 1);
        $ano = @date('Y');
        if ($mes < 01) {
            $mes = '12';
            $ano--;
        }
        if ($mes < 10) {
            $mes = '0' . $mes;
        }
        return $mes . $ano;
    }

    public function getInformacoes() {
        $responsavel = unserialize($this->servico->getObjeto('usuarioRestritoLogadoSerializado'));
        $info = $this->fachada->getInformacoesInicio($responsavel->getId());
        $informacoes = new InformacoesInicio($info[0]['solicitantes'], $info[0]['meusChamados'], $info[0]['novosChamados']);
        return $informacoes;
    }

    public function retornaListaClientesJSON($consulta) {
        //consulta={"login":"","senha":"","busca":""}
        if ($consulta != NULL) {
            $objeto = json_decode($consulta);
            $login = (!empty($objeto->login) ? $objeto->login : NULL);
            $senha = (!empty($objeto->senha) ? $objeto->senha : NULL);
            $busca = (!empty($objeto->busca) ? $objeto->busca : NULL);
			$sistema = (!empty($objeto->sistema) ? $objeto->sistema : NULL);
			$cnpj = (!empty($objeto->cnpj) ? $objeto->cnpj : '%');
            if ($login != NULL && $senha != NULL) {
                $verificador = $this->fachada->logarRestrito($login, $this->getMd5($senha));
                if ($verificador != NULL) {
					$clientes = array();
					if($sistema == NULL){
                    	$clientes = $this->fachada->buscarClientes(utf8_decode($busca), NULL, 'S', 'ativo', NULL);
					} else {
						$clientes = $this->fachada->buscarClientesPorSistema($sistema, $cnpj);
					}
                    return $clientes;
                }
            }
        }
        return array();
    }

    /** Usurio Restrito ***************************************************** */
    private $usuario;

    public function logar($login, $senha) {
        if ($login != "" && $senha != "") {
            $this->usuario = new UsuarioRestrito();
            $senha = $this->getMd5($senha);
            $this->usuario = $this->fachada->logarRestrito($login, $senha);
            if ($this->usuario != NULL) {
                $this->servico->setObjeto("nivelRestrito", $this->usuario->getNivel());
                $this->servico->setObjeto("usuarioRestritoLogado", $this->usuario);
                $this->servico->setObjeto("usuarioRestritoLogadoSerializado", serialize($this->usuario));
                $this->servico->setObjeto("usuarioRestrito", $this->usuario->getNome());
                header("location: controle/inicio.php");
            } else {
                $this->servico->setMessage("Usurio ou Senha esto incorretos!", 3);
                header("location: clientes.php");
            }
        } else {
            die("Error ao logar");
        }
    }

    public function sair() {
        $this->servico->destroyObjeto("usuarioRestrito");
        $this->servico->destroyObjeto("usuarioRestritoLogado");
        $this->servico->setMessage("Voc saiu do sistema!", 2);
        header("location: clientes.php");
    }

    public function cadastrarUsuario($nome, $login, $senha) {
        $usuario = new UsuarioRestrito();
        $usuario->setLiberado("N");
        $usuario->setNivel(0);
        $usuario->setNome(utf8_decode($nome));
        $usuario->setSenha($this->getMd5($senha));
        $usuario->setUsuario(utf8_decode($login));
        $usuario->setStatusUsuario("Ativo");
        if (!$this->verificaLogin($login)) {
            $this->servico->setMessage("Este login j existe, por favor tente outro login!", 3);
            header("location: cadastroUsuarioRestrito.php");
        } else {
            $retorno = $this->fachada->salvar($usuario);
            if ($retorno != 0) {
                $this->servico->setMessage("Usurio salvo com sucesso!<br/>Dentro de alguns instantes seu usurio ser liberado.", 2);
                header("location: cadastroUsuarioRestrito.php");
            } else {
                $this->servico->setMessage("No foi possivel salvar este usurio!", 1);
                header("location: cadastroUsuarioRestrito.php");
            }
        }
    }

    public function buscarUsuarios($nome, $status, $liberado, $todos) {
        $usuarios = $this->fachada->buscarUsuariosRestritos($nome, $status, $liberado, $todos);
        return $usuarios;
    }

    public function verificaLogin($login) {
        $resultado = $this->fachada->verificaLoginRestrito($login);
        if ($resultado > 0) {
            return false;
        }
        return true;
    }

    public function inativarUsuario($id) {
        $usuario = $this->fachada->find(new UsuarioRestrito(), $id);
        $usuario->setId($id);
        $usuario->setStatusUsuario("Inativo");
        $usuario->setLiberado("N");
        $this->fachada->alterar($usuario);
        $this->servico->setMessage("Usurio inativado com sucesso!", 2);
        header('location: ' . $_SERVER['HTTP_REFERER']);
    }

    public function ativarUsuario($id) {
        $usuario = $this->fachada->find(new UsuarioRestrito(), $id);
        $usuario->setId($id);
        $usuario->setStatusUsuario("Ativo");
        $usuario->setLiberado("S");
        $this->fachada->alterar($usuario);
        $this->servico->setMessage("Usurio inativado com sucesso!", 2);
        header('location: ' . $_SERVER['HTTP_REFERER']);
    }

    public function bloquearUsuario($id) {
        $usuario = $this->fachada->find(new UsuarioRestrito(), $id);
        $usuario->setId($id);
        $usuario->setStatusUsuario("Ativo");
        $usuario->setLiberado("N");
        $this->fachada->alterar($usuario);
        $this->servico->setMessage("Usurio bloqueado com sucesso!", 2);
        header('location: ' . $_SERVER['HTTP_REFERER']);
    }

    public function liberarUsuario($id, $nivel) {
        $usuario = $this->fachada->find(new UsuarioRestrito(), $id);
        if ($usuario != NULL) {
            $usuario->setLiberado("S");
            $usuario->setNivel($nivel);
            $usuario->setStatusUsuario("Ativo");
            $retorno = $this->fachada->alterar($usuario);
            if ($retorno != NULL) {
                $this->servico->setMessage("Usurio liberado com sucesso!", 2);
                 header('location: ' . $_SERVER['HTTP_REFERER']);
            } else {
                $this->servico->setMessage("No foi possivel liberar este usurio!", 3);
                 header('location: ' . $_SERVER['HTTP_REFERER']);
            }
        }
    }

    public function alterarConta($id, $nome) {
        $usuario = new UsuarioRestrito();
        $usuario->setId($id);
        $usuario->setNome(utf8_decode($nome));
        $this->fachada->alterar($usuario);
        $this->servico->setMessage("Sua conta foi alterada com sucesso!<br/>Efetue o login novamente para para visualizar suas alteraes", 2);
        header("location: controle/configuracoes.php");
    }

    public function cancelarConta() {
        $usuario = $this->servico->getObjeto('usuarioRestritoLogado');
        $usuario->setStatusUsuario("Inativo");
        $usuario->setLiberado("N");
        $this->fachada->alterar($usuario);
        $this->servico->setMessage("Sua conta foi cancelada com sucesso!", 2);
        $this->sair();
    }

    public function alterarSenha($senhaAtual, $senhaNova) {
        $usuario = $this->servico->getObjeto('usuarioRestritoLogado');
        if ($usuario->getSenha() == $this->getMd5($senhaAtual)) {
            $usuario->setSenha($this->getMd5($senhaNova));
            $this->fachada->alterar($usuario);
            $this->servico->setMessage("Sua senha foi alterada com sucesso!<br />Efetue novamente o login.", 2);
            header("location: controle/configuracoes.php");
        } else {
            $this->servico->setMessage("Sua senha atual no confere com a senha digitada!", 1);
            header("location: controle/configuracoes.php");
        }
    }

    private function getMd5($senha) {
        return md5($senha);
    }

    public function getUsuario() {
        return $this->usuario;
    }

    public function setUsuario($usuario) {
        $this->usuario = $usuario;
    }

}

class InformacoesInicio {

    public $solicitantes;
    public $meusChamados;
    public $novosChamados;

    function __construct($solicitantes, $meusChamados, $novosChamados) {
        $this->solicitantes = $solicitantes;
        $this->meusChamados = $meusChamados;
        $this->novosChamados = $novosChamados;
    }

}

?>
