<?php

require_once 'modelos/Usuario.class.php';
require_once 'modelos/UsuarioRestrito.class.php';
require_once 'fachada/Fachada.class.php';
require_once 'service/ServiceMessages.class.php';

/**
 * @author Eticons
 */
abstract class GerenciadorABS {

    public $fachada;
    public $servico;

    function __construct() {
        $this->fachada = new Fachada();
        $this->servico = ServiceMessages::getInstancia();
    }

    /**
     * Recebe uma data no formato dd/mm/aaaa
     * @param <type> $data
     * @return data no formato sql aaaa/mm/dd, se $data for "" retorna a data atual
     */
    public function converteDataSql($data) {
        if ($data != "") {
            $dia = substr($data, 0, 2);
            $mes = substr($data, 3, 2);
            $ano = substr($data, 6, 10);
            return $ano . "-" . $mes . "-" . $dia;
        }
        return date('Y/m/d H:i:s');
    }

}

?>
