<?php

function __autoload($class_name) {
    require 'beans/' . $class_name . '.class.php';
}

init();

function init() {

    $solicitacao = null;
    if (!empty($_REQUEST)) {
        $solicitacao = $_REQUEST;
    } else if (!empty($_POST)) {
        $solicitacao = $_POST;
    } else if (!empty($_GET)) {
        $solicitacao = $_GET;
    }
    $files = array_keys($_FILES); //obs
    foreach ($_FILES as $i => $file) {
        if ($file['error'] == 0) {
            $files[$i] = $file;
        }
    }
    $objeto = $solicitacao['metodo'];
    $method = substr($objeto, stripos($objeto, ".") + 1);
	$class = substr($objeto, 0, strpos($objeto, '.'));
    try {
        $classe = new ReflectionClass($class);
        if (!is_null($solicitacao)) {
            $metodo = $classe->getMethod($method);
            $params = $metodo->getParameters();
            if (!empty($params)) {
                foreach ($params as $i => $p) {
                    if (array_key_exists($p->getName(), $files)) {
                        $parametros[$i] = $files[$p->getName()];
                    } else if (array_key_exists($p->getName(), $solicitacao)) {
                        $parametros[$i] = $solicitacao[$p->getName()];
                    } else {
                        $parametros[$i] = "";
                    }
                }
                $class = get_class(new $class);
                $metodo->invokeArgs(new $class, $parametros);
            } else {
                $class = get_class(new $class);
                $metodo->invoke(new $class);
            }
        }
    } catch (Exception $ex) {
        die($ex);
    }
    if (!empty($solicitacao['redirect'])) {
        $redirect = $solicitacao['redirect'];
        header('location: ' . $redirect);
    }
}

?>